/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Variables
implements Map<String, String>,
Serializable {
    private static final long serialVersionUID = -8120239592664368847L;
    static Logger log = LoggerFactory.getLogger(Variables.class);
    public static final String VAR_PREFIX = "${";
    public static final String VAR_SUFFIX = "}";
    Variables parentContext = null;
    protected HashMap<String, String> variables = new HashMap();

    public Variables() {
        this(new HashMap<String, String>());
    }

    public Variables(Variables root) {
        this.variables = new HashMap();
        this.parentContext = root;
    }

    public Variables(Map<String, String> variables) {
        this.variables = new HashMap<String, String>(variables);
    }

    public Variables(Properties p) {
        this.variables = new HashMap();
        for (Object k : p.keySet()) {
            this.variables.put(k.toString(), p.getProperty(k.toString()));
        }
    }

    public void addVariables(Map<String, String> vars) {
        for (String key : vars.keySet()) {
            this.variables.put(key, vars.get(key));
        }
    }

    public void set(String key, String val) {
        this.variables.put(key, val);
    }

    public Map<String, String> expandAll(Map<String, String> vars) {
        LinkedHashMap<String, String> expanded = new LinkedHashMap<String, String>();
        for (String var : vars.keySet()) {
            expanded.put(var, this.expand(vars.get(var)));
        }
        return expanded;
    }

    public String expand(String str, boolean emptyStrings) {
        return this.substitute(str, emptyStrings);
    }

    public String expand(String str) {
        return this.substitute(str, false);
    }

    private String substitute(String str, boolean emptyStrings) {
        String content = str;
        int start = content.indexOf(VAR_PREFIX, 0);
        while (start >= 0) {
            int end = content.indexOf(VAR_SUFFIX, start + 1);
            if (end >= start + 2) {
                String variable = content.substring(start + 2, end);
                log.debug("Found variable: {}", (Object)variable);
                log.trace("   content is: {}", (Object)content);
                int len = variable.length();
                if (this.containsKey(variable)) {
                    String repl = this.get(variable);
                    if (repl == null) {
                        log.info("lookup of '{}' revealed: {}", (Object)variable, (Object)repl);
                    }
                    content = content.substring(0, start) + this.get(variable) + content.substring(end + 1);
                    len = repl.length();
                } else if (emptyStrings) {
                    content = content.substring(0, start) + "" + content.substring(end + 1);
                    len = 0;
                } else {
                    content = content.substring(0, start) + VAR_PREFIX + variable + VAR_SUFFIX + content.substring(end + 1);
                }
                if (end < content.length()) {
                    start = content.indexOf(VAR_PREFIX, start + len);
                    continue;
                }
                start = -1;
                continue;
            }
            start = -1;
        }
        return content;
    }

    protected boolean containsKey(String key) {
        return this.variables.containsKey(key) || this.parentContext != null && this.parentContext.containsKey(key);
    }

    public String get(String key) {
        String val = this.variables.get(key);
        if (val != null) {
            return val;
        }
        if (this.parentContext != null) {
            val = this.parentContext.get(key);
        }
        if (val == null) {
            val = System.getProperty(key);
        }
        return val;
    }

    @Override
    public void clear() {
        this.variables.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.parentContext != null) {
            return this.parentContext.containsKey(key) || this.variables.containsKey(key);
        }
        return this.variables.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.parentContext != null) {
            return this.parentContext.containsValue(value) || this.variables.containsValue(value);
        }
        return this.variables.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        LinkedHashSet<Map.Entry<String, String>> entries = new LinkedHashSet<Map.Entry<String, String>>();
        if (this.parentContext != null) {
            entries.addAll(this.parentContext.entrySet());
        }
        entries.addAll(this.variables.entrySet());
        return entries;
    }

    @Override
    public String get(Object key) {
        if (key == null) {
            return null;
        }
        return this.get(key.toString());
    }

    @Override
    public boolean isEmpty() {
        if (this.parentContext != null) {
            return this.variables.isEmpty() && this.parentContext.isEmpty();
        }
        return this.variables.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        if (this.parentContext != null) {
            TreeSet<String> keys = new TreeSet<String>(this.parentContext.keySet());
            keys.addAll(this.variables.keySet());
            return keys;
        }
        return this.variables.keySet();
    }

    @Override
    public String put(String key, String value) {
        return this.variables.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        this.variables.putAll(m);
    }

    @Override
    public String remove(Object key) {
        return this.variables.remove(key);
    }

    @Override
    public int size() {
        if (this.parentContext == null) {
            return this.variables.size();
        }
        return this.variables.size() + this.parentContext.size();
    }

    @Override
    public Collection<String> values() {
        ArrayList<String> vals = new ArrayList<String>();
        if (this.parentContext != null) {
            vals.addAll(this.parentContext.values());
        }
        vals.addAll(this.variables.values());
        return vals;
    }
}

