/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.annotations.BodyContent;
import stream.expressions.Condition;
import stream.runtime.Variables;
import stream.runtime.setup.ParameterDiscovery;
import stream.runtime.setup.ParameterUtils;
import stream.runtime.setup.ServiceInjection;

public class ParameterInjection {
    static Logger log = LoggerFactory.getLogger(ParameterInjection.class);

    public static Set<String> inject(Object o, Map<String, ?> params, Variables variableContext) throws Exception {
        log.debug("Injecting parameters {} into object {}", (Object)params, o);
        HashSet<String> alreadySet = new HashSet<String>();
        Object embedded = params.get("__EMBEDDED_CONTENT__");
        for (Method m : o.getClass().getMethods()) {
            Class<?>[] t = m.getParameterTypes();
            if (ServiceInjection.isServiceSetter(m)) {
                log.debug("Skipping ServiceSetter '{}'", (Object)m.getName());
                continue;
            }
            if (embedded != null && m.getName().startsWith("set") && t.length == 1 && t[0] == BodyContent.class) {
                log.debug("Setting embedded content...");
                m.invoke(o, new BodyContent(embedded.toString()));
                continue;
            }
            for (String k : params.keySet()) {
                if (m.getName().startsWith("set") && alreadySet.contains(k)) {
                    log.debug("Skipping setter '{}' for already injected field {}", (Object)m.getName(), (Object)k);
                    continue;
                }
                if (!m.getName().equalsIgnoreCase("set" + k) || m.getParameterTypes().length != 1) continue;
                if (t.equals(params.get(k).getClass())) {
                    log.debug("Using setter '{}' to inject parameter '{}'", (Object)m.getName(), (Object)k);
                    m.invoke(o, params.get(k));
                    alreadySet.add(k);
                    continue;
                }
                Object po = null;
                if (t[0].isPrimitive()) {
                    String in = params.get(k).toString();
                    if (t[0] == Double.TYPE) {
                        po = new Double(in);
                    }
                    if (t[0] == Integer.TYPE) {
                        po = new Integer(in);
                    }
                    if (t[0] == Boolean.TYPE) {
                        po = new Boolean(in);
                    }
                    if (t[0] == Float.TYPE) {
                        po = new Float(in);
                    }
                } else if (t[0].isArray()) {
                    log.debug("setter is an array, using split(,) and array creation...");
                    String[] args = ParameterUtils.split(params.get(k).toString());
                    Class<?> content = t[0].getComponentType();
                    Constructor<?> c = content.getConstructor(String.class);
                    Object array = Array.newInstance(content, args.length);
                    for (int i = 0; i < args.length; ++i) {
                        Object value = c.newInstance(args[i]);
                        Array.set(array, i, value);
                    }
                    po = array;
                } else {
                    try {
                        Constructor<?> c = t[0].getConstructor(String.class);
                        po = c.newInstance(params.get(k).toString());
                        log.debug("Invoking {}({})", (Object)m.getName(), po);
                    }
                    catch (NoSuchMethodException nsm) {
                        log.error("No String-constructor found for type {} of method {}", (Object)t, (Object)m.getName());
                    }
                }
                m.invoke(o, po);
                alreadySet.add(k);
            }
        }
        return alreadySet;
    }

    public static void injectSystemProperties(Object object, String prefix) throws Exception {
        Map<String, String> params = ParameterDiscovery.getSystemProperties(prefix);
        ParameterInjection.inject(object, params, new Variables());
    }

    public static Map<String, String> extract(Object learner) throws Exception {
        TreeMap<String, String> params = new TreeMap<String, String>();
        for (Method m : learner.getClass().getMethods()) {
            String name = m.getName();
            if (!name.startsWith("get") || m.getParameterTypes().length != 0) continue;
            log.debug("Found getter '{}' for class '{}'", (Object)name, (Object)learner.getClass());
            Class<?> rt = m.getReturnType();
            if (!ParameterInjection.isTypeSupported(rt)) continue;
            Object val = m.invoke(learner, new Object[0]);
            String key = ParameterDiscovery.getParameterName(m);
            if (key == null || val == null) continue;
            if (val.getClass().isArray()) {
                int len = Array.getLength(val);
                StringBuffer s = new StringBuffer();
                for (int i = 0; i < len; ++i) {
                    s.append(Array.get(val, i) + "");
                    if (i + 1 >= len) continue;
                    s.append(",");
                }
                params.put(key, s.toString());
                continue;
            }
            params.put(key, "" + val);
        }
        return params;
    }

    public static boolean isGetter(Method m) {
        return ParameterDiscovery.isGetter(m);
    }

    public static boolean hasGetter(Class<?> clazz, String name) {
        try {
            for (Method m : clazz.getMethods()) {
                if (!ParameterInjection.isGetter(m) || !m.getName().equalsIgnoreCase("get" + name)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isTypeSupported(Class<?> clazz) {
        if (ServiceInjection.isServiceImplementation(clazz)) {
            return false;
        }
        if (clazz.isArray() && ParameterInjection.isNativeType(clazz.getComponentType())) {
            return true;
        }
        if (clazz.equals(String.class) || clazz.equals(Long.class) || clazz.equals(Integer.class) || clazz.equals(Double.class) || clazz.equals(Boolean.class) || clazz.equals(File.class) || clazz.equals(BodyContent.class) || clazz.equals(Boolean.TYPE) || clazz.equals(Integer.TYPE) || clazz.isPrimitive() || clazz.equals(Condition.class) || clazz.equals(Map.class)) {
            return true;
        }
        return clazz.isPrimitive();
    }

    public static boolean isNativeType(Class<?> clazz) {
        return clazz.equals(String.class) || clazz.equals(Long.class) || clazz.equals(Integer.class) || clazz.equals(Double.class) || clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE);
    }
}

