/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup;

import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import stream.io.SourceURL;
import stream.runtime.Container;
import stream.runtime.ContainerFactory;
import stream.runtime.DefaultNamingService;
import stream.runtime.ElementHandler;
import stream.runtime.ProcessContainer;
import stream.runtime.Variables;
import stream.runtime.setup.ObjectFactory;
import stream.runtime.setup.ProcessorFactory;
import stream.runtime.setup.handler.ContainerRefElementHandler;
import stream.runtime.setup.handler.DocumentHandler;
import stream.runtime.setup.handler.LibrariesElementHandler;
import stream.runtime.setup.handler.MonitorElementHandler;
import stream.runtime.setup.handler.ProcessElementHandler;
import stream.runtime.setup.handler.PropertiesHandler;
import stream.runtime.setup.handler.QueueElementHandler;
import stream.runtime.setup.handler.ServiceElementHandler;
import stream.runtime.setup.handler.StreamElementHandler;
import stream.service.NamingService;

public class StreamsContainerFactory
implements ContainerFactory {
    static Logger log = LoggerFactory.getLogger(StreamsContainerFactory.class);
    protected final ObjectFactory objectFactory = ObjectFactory.newInstance();
    protected final ProcessorFactory processorFactory = new ProcessorFactory(this.objectFactory);
    protected final List<DocumentHandler> documentHandler = new ArrayList<DocumentHandler>();
    protected final Map<String, ElementHandler> elementHandler = new HashMap<String, ElementHandler>();

    public StreamsContainerFactory() {
        LibrariesElementHandler libHandler = new LibrariesElementHandler(this.objectFactory);
        this.documentHandler.add(libHandler);
        this.documentHandler.add(new PropertiesHandler());
        this.elementHandler.put("Container-Ref", new ContainerRefElementHandler(this.objectFactory));
        this.elementHandler.put("Queue", new QueueElementHandler());
        this.elementHandler.put("Monitor", new MonitorElementHandler(this.objectFactory, this.processorFactory));
        this.elementHandler.put("Process", new ProcessElementHandler(this.objectFactory, this.processorFactory));
        this.elementHandler.put("Stream", new StreamElementHandler(this.objectFactory));
        this.elementHandler.put("Service", new ServiceElementHandler(this.objectFactory));
        this.elementHandler.put("Libs", libHandler);
    }

    @Override
    public Container create(SourceURL url) throws Exception {
        return this.create(url.openStream());
    }

    @Override
    public Container create(InputStream in) throws Exception {
        Document doc = this.parseXML(in);
        NamingService namingService = this.createNamingService();
        ProcessContainer container = null;
        container = this.buildContainer(container, doc);
        String host = InetAddress.getLocalHost().getHostAddress();
        String name = InetAddress.getLocalHost().getHostName();
        if (name.indexOf(".") > 0) {
            name = name.substring(0, name.indexOf("."));
        }
        return null;
    }

    protected Document parseXML(InputStream input) throws Exception {
        log.debug("Parsing XML from inputstream");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(input);
        if (!doc.getDocumentElement().getNodeName().equalsIgnoreCase("container")) {
            log.error("Invalid XML root-element '{}'", (Object)doc.getDocumentElement().getNodeName());
            throw new Exception("Expecting root element to be 'container'!");
        }
        return doc;
    }

    protected NamingService createNamingService() {
        return new DefaultNamingService();
    }

    protected ProcessContainer buildContainer(ProcessContainer container, Document doc) throws Exception {
        Variables variables = new Variables();
        Element root = doc.getDocumentElement();
        for (DocumentHandler docHandler : this.documentHandler) {
            log.debug("Calling document-handler {}", (Object)docHandler);
            docHandler.handle(container, doc, variables);
        }
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) {
                log.debug("Skipping non-element node '{}'", (Object)node);
                continue;
            }
            Element element = (Element)node;
            for (String key : this.elementHandler.keySet()) {
                ElementHandler handler = this.elementHandler.get(key);
                log.debug("Calling ElementHandler '{}' ({})", (Object)key, (Object)handler);
                if (!handler.handlesElement(element)) continue;
                handler.handleElement(container, element, new Variables(variables));
            }
        }
        return container;
    }

    public void addElementHandler(String name, ElementHandler handler) {
        this.elementHandler.put(name, handler);
    }
}

