/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup.handler;

import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import stream.Processor;
import stream.runtime.Monitor;
import stream.runtime.ProcessContainer;
import stream.runtime.Variables;
import stream.runtime.setup.ObjectFactory;
import stream.runtime.setup.ProcessorFactory;
import stream.runtime.setup.handler.ProcessElementHandler;

public class MonitorElementHandler
extends ProcessElementHandler {
    static Logger log = LoggerFactory.getLogger(MonitorElementHandler.class);

    public MonitorElementHandler(ObjectFactory objectFactory, ProcessorFactory processorFactory) {
        super(objectFactory, processorFactory);
    }

    @Override
    public String getKey() {
        return "Monitor";
    }

    @Override
    public boolean handlesElement(Element element) {
        return "monitor".equalsIgnoreCase(element.getNodeName());
    }

    @Override
    public void handleElement(ProcessContainer container, Element element, Variables variables) throws Exception {
        Map<String, String> params = this.objectFactory.getAttributes(element);
        Map<String, String> attr = this.objectFactory.getAttributes(element);
        String copies = attr.get("copies");
        if (attr.containsKey("multiply")) {
            copies = attr.get("multiply");
            log.warn("The attribute 'multiply' is deprecated for element 'Process'");
            log.warn("Please use 'copies' instead of 'multiply'.");
        }
        if (copies != null && !"".equals(copies.trim())) {
            String[] ids;
            Variables var = new Variables(variables);
            log.debug("Expanding '{}'", (Object)copies);
            copies = var.expand(copies);
            if (copies.indexOf(",") >= 0) {
                ids = copies.split(",");
            } else {
                Integer times = new Integer(copies);
                ids = new String[times.intValue()];
                for (int i = 0; i < times; ++i) {
                    ids[i] = "" + i;
                }
            }
            log.debug("Creating {} processes due to copies='{}'", (Object)ids.length, (Object)copies);
            for (String pid : ids) {
                Variables local = new Variables(variables);
                local.put("monitor.id", pid);
                local.put("copy.id", pid);
                String className = "stream.runtime.Monitor";
                Monitor monitor = (Monitor)this.objectFactory.create(className, params);
                List<Processor> procs = this.createNestedProcessors(container, element, local);
                for (Processor p : procs) {
                    monitor.add(p);
                }
                log.debug("Created Monitor object: {}", (Object)monitor);
                container.getProcesses().add(monitor);
            }
        } else {
            Variables local = new Variables(variables);
            this.objectFactory.set("monitor.id", "0");
            local.put("monitor.id", "0");
            String className = "stream.runtime.Monitor";
            Monitor monitor = (Monitor)this.objectFactory.create(className, params);
            List<Processor> procs = this.createNestedProcessors(container, element, local);
            for (Processor p : procs) {
                monitor.add(p);
            }
            log.debug("Created Monitor object: {}", (Object)monitor);
            container.getProcesses().add(monitor);
        }
    }
}

