/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup.handler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import stream.Processor;
import stream.ProcessorList;
import stream.runtime.DefaultProcess;
import stream.runtime.ElementHandler;
import stream.runtime.ProcessContainer;
import stream.runtime.ProcessContextImpl;
import stream.runtime.Variables;
import stream.runtime.setup.ObjectFactory;
import stream.runtime.setup.ProcessorFactory;
import stream.runtime.setup.ServiceInjection;
import stream.runtime.setup.ServiceReference;
import stream.service.Service;

public class ProcessElementHandler
implements ElementHandler {
    static Logger log = LoggerFactory.getLogger(ProcessElementHandler.class);
    protected final ObjectFactory objectFactory;
    protected final ProcessorFactory processorFactory;
    protected final String defaultProcessImplementation = "stream.runtime.DefaultProcess";

    public ProcessElementHandler(ObjectFactory objectFactory, ProcessorFactory processorFactory) {
        this.objectFactory = objectFactory;
        this.processorFactory = processorFactory;
    }

    @Override
    public String getKey() {
        return "Process";
    }

    @Override
    public boolean handlesElement(Element element) {
        return "process".equalsIgnoreCase(element.getNodeName());
    }

    @Override
    public void handleElement(ProcessContainer container, Element element, Variables variables) throws Exception {
        String id;
        Map<String, String> attr = this.objectFactory.getAttributes(element);
        String src = attr.get("source");
        if (src == null) {
            src = attr.get("input");
        }
        String out = attr.get("output");
        String processClass = "stream.runtime.DefaultProcess";
        if (attr.containsKey("class")) {
            processClass = attr.get("class");
            log.debug("Using custom process class '{}'", (Object)processClass);
        }
        if ((id = attr.get("id")) == null || "".equals(id.trim())) {
            id = "process";
        }
        String copies = attr.get("copies");
        if (attr.containsKey("multiply")) {
            copies = attr.get("multiply");
            log.warn("The attribute 'multiply' is deprecated for element 'Process'");
            log.warn("Please use 'copies' instead of 'multiply'.");
        }
        if (copies != null && !"".equals(copies.trim())) {
            String[] ids;
            Variables var = new Variables(variables);
            log.debug("Expanding '{}'", (Object)copies);
            copies = var.expand(copies);
            if (copies.indexOf(",") >= 0) {
                ids = copies.split(",");
            } else {
                Integer times = new Integer(copies);
                ids = new String[times.intValue()];
                for (int i = 0; i < times; ++i) {
                    ids[i] = "" + i;
                }
            }
            log.debug("Creating {} processes due to copies='{}'", (Object)ids.length, (Object)copies);
            for (String pid : ids) {
                Variables local = new Variables(variables);
                local.put("process.id", pid);
                local.put("copy.id", pid);
                log.debug("Creating process '{}'", (Object)pid);
                DefaultProcess process = this.createProcess(processClass, attr, container, element, local);
                String input = local.expand(src);
                log.debug("Setting source for process {} to {}", (Object)process, (Object)input);
                process.setInput(input);
                if (out != null) {
                    String processOut = local.expand(out);
                    log.debug("Setting process output for process {} to {}", (Object)process, (Object)processOut);
                    process.setOutput(processOut);
                } else {
                    log.debug("Process has no output connection...");
                }
                container.getProcesses().add(process);
            }
        } else {
            Variables local = new Variables(variables);
            this.objectFactory.set("process.id", id);
            local.put("process.id", id);
            DefaultProcess process = this.createProcess(processClass, attr, container, element, local);
            log.debug("Created Process object: {}", (Object)process);
            container.getProcesses().add(process);
        }
    }

    protected DefaultProcess createProcess(String processClass, Map<String, String> attr, ProcessContainer container, Element element, Variables extraVariables) throws Exception {
        log.debug("Creating 'process' element, variable context is:");
        for (String key : extraVariables.keySet()) {
            log.debug("  '{}' = '{}'", (Object)key, (Object)extraVariables.get(key));
        }
        DefaultProcess process = (DefaultProcess)this.objectFactory.create(processClass, attr, extraVariables);
        log.debug("Created Process object: {}", (Object)process);
        log.debug("Process input is: '{}'", (Object)process.getInput());
        ProcessContextImpl ctx = new ProcessContextImpl(container.getContext());
        for (String key : attr.keySet()) {
            ctx.set(key, attr.get(key));
        }
        for (String key : extraVariables.keySet()) {
            ctx.set(key, extraVariables.get(key));
        }
        container.setProcessContext(process, ctx);
        List<Processor> procs = this.createNestedProcessors(container, element, extraVariables);
        for (Processor p : procs) {
            process.add(p);
            container.getDependencyGraph().add(process, p);
        }
        return process;
    }

    protected Processor createProcessor(ProcessContainer container, Element child, Variables variables) throws Exception {
        Map<String, String> params = this.objectFactory.getAttributes(child);
        Object o = this.objectFactory.create(child, (Map<String, String>)variables);
        if (o instanceof Processor) {
            Variables vctx = new Variables(variables);
            if (o instanceof ProcessorList) {
                NodeList children = child.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node node = children.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    Processor proc = this.createProcessor(container, element, variables);
                    if (proc != null) {
                        ((ProcessorList)o).getProcessors().add(proc);
                        continue;
                    }
                    log.warn("Nested element {} is not of type 'stream.data.Processor': ", (Object)node.getNodeName());
                }
            }
            if (params.containsKey("id") && !"".equals(params.get("id").trim())) {
                if (o instanceof Service) {
                    String id = params.get("id").trim();
                    id = vctx.expand(id);
                    log.debug("Registering processor with id '{}' in look-up service", (Object)id);
                    container.getContext().register(id, (Service)o);
                } else {
                    log.warn("Processor '{}' specifies an ID attribute '{}' but does not implement a Service interface. Processor will *not* be registered!", (Object)o.getClass().getName(), (Object)params.get("id"));
                }
            }
            Iterator<String> i$ = params.keySet().iterator();
            while (i$.hasNext()) {
                Class<? extends Service> serviceClass;
                String key;
                String k = key = i$.next();
                if (key.endsWith("-ref")) {
                    key = key.replace("-ref", "");
                }
                if ((serviceClass = ServiceInjection.hasServiceSetter(key, o)) == null) continue;
                log.info("Found service setter for key '{}' in processor {}", (Object)key, o);
                String ref = params.get(k);
                ref = vctx.expand(ref);
                ServiceReference serviceRef = new ServiceReference(ref, o, key, serviceClass);
                container.getServiceRefs().add(serviceRef);
            }
            return (Processor)o;
        }
        return null;
    }

    protected List<Processor> createNestedProcessors(ProcessContainer container, Element child, Variables variables) throws Exception {
        ArrayList<Processor> procs = new ArrayList<Processor>();
        NodeList pnodes = child.getChildNodes();
        for (int j = 0; j < pnodes.getLength(); ++j) {
            Processor p;
            Node cnode = pnodes.item(j);
            if (cnode.getNodeType() != 1 || (p = this.createProcessor(container, (Element)cnode, variables)) == null) continue;
            log.debug("Found processor...");
            procs.add(p);
        }
        return procs;
    }
}

