/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup.handler;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import stream.runtime.ProcessContainer;
import stream.runtime.Variables;
import stream.runtime.setup.handler.DocumentHandler;

public class PropertiesHandler
implements DocumentHandler {
    static Logger log = LoggerFactory.getLogger(PropertiesHandler.class);

    @Override
    public void handle(ProcessContainer container, Document doc, Variables variables) throws Exception {
        this.findPropertiesElements(container, doc, variables);
        this.findPropertyElements(container, doc, variables);
    }

    private void findPropertiesElements(ProcessContainer container, Document doc, Variables variables) {
        NodeList list = doc.getElementsByTagName("properties");
        for (int i = 0; i < list.getLength(); ++i) {
            Element prop = (Element)list.item(i);
            NodeList children = prop.getChildNodes();
            for (int k = 0; k < children.getLength(); ++k) {
                Node ch = children.item(k);
                if (ch.getNodeType() != 1) continue;
                String key = ch.getNodeName();
                String value = ch.getTextContent();
                variables.set(key, value);
            }
            if (prop.hasAttribute("url")) {
                String purl = prop.getAttribute("url");
                try {
                    URL propUrl = purl.toLowerCase().startsWith("classpath:") ? PropertiesHandler.class.getResource(purl.substring("classpath:".length())) : new URL(prop.getAttribute("url"));
                    Properties p = new Properties();
                    p.load(propUrl.openStream());
                    for (Object k : p.keySet()) {
                        variables.set(k.toString(), p.getProperty(k.toString()));
                    }
                }
                catch (Exception e) {
                    log.error("Failed to read properties from url {}: {}", (Object)purl, (Object)e.getMessage());
                }
            }
            if (!prop.hasAttribute("file")) continue;
            File file = new File(prop.getAttribute("file"));
            try {
                Properties p = new Properties();
                p.load(new FileInputStream(file));
                for (Object k : p.keySet()) {
                    variables.set(k.toString(), p.getProperty(k.toString()));
                }
                continue;
            }
            catch (Exception e) {
                log.error("Failed to read properties from file {}: {}", (Object)file, (Object)e.getMessage());
            }
        }
    }

    private void findPropertyElements(ProcessContainer container, Document doc, Variables variables) {
        NodeList ch = doc.getElementsByTagName("property");
        for (int i = 0; i < ch.getLength(); ++i) {
            Element el;
            Node child = ch.item(i);
            if (!(child instanceof Element) || !(el = (Element)child).getNodeName().equalsIgnoreCase("property")) continue;
            String key = el.getAttribute("name");
            String value = el.getAttribute("value");
            if (key == null || "".equals(key.trim()) || value == null || "".equals(value.trim())) continue;
            String k = key.trim();
            String v = value.trim();
            variables.set(k, v);
        }
    }
}

