/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup.handler;

import java.io.FileNotFoundException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import stream.io.Stream;
import stream.runtime.ElementHandler;
import stream.runtime.ProcessContainer;
import stream.runtime.Variables;
import stream.runtime.setup.ObjectFactory;
import stream.runtime.setup.ProcessorFactory;
import stream.runtime.setup.StreamFactory;
import stream.service.Service;

public class StreamElementHandler
implements ElementHandler {
    static Logger log = LoggerFactory.getLogger(StreamElementHandler.class);
    final ObjectFactory objectFactory;
    final ProcessorFactory processorFactory;

    public StreamElementHandler(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
        this.processorFactory = new ProcessorFactory(objectFactory);
    }

    @Override
    public String getKey() {
        return "Stream";
    }

    @Override
    public boolean handlesElement(Element element) {
        if (element == null) {
            return false;
        }
        return "Stream".equalsIgnoreCase(element.getNodeName()) || "DataStream".equalsIgnoreCase(element.getNodeName());
    }

    @Override
    public void handleElement(ProcessContainer container, Element element, Variables variables) throws Exception {
        try {
            Map<String, String> attr = this.objectFactory.getAttributes(element);
            String id = attr.get("id");
            Stream stream = StreamFactory.createStream(this.objectFactory, element, variables);
            if (stream != null) {
                if (id == null) {
                    id = "" + stream;
                }
                stream.setId(id);
                container.setStream(id, stream);
            }
            if (stream instanceof Service) {
                container.getContext().register(id, (Service)((Object)stream));
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new Exception("Cannot create stream from referenced file: " + fnfe.getMessage());
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                throw new Exception(e.getCause());
            }
            log.error("Failed to create stream-object: {}", (Object)e.getMessage());
            e.printStackTrace();
            throw new Exception("Failed to create data-stream: " + e.getMessage());
        }
    }
}

