/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.shutdown;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Process;
import stream.runtime.LifeCycle;
import stream.runtime.ProcessListener;

public class DependencyGraph
implements ProcessListener {
    static Logger log = LoggerFactory.getLogger(DependencyGraph.class);
    final Set<Object> nodes = new LinkedHashSet<Object>();
    final List<Edge> edges = new ArrayList<Edge>();

    public synchronized void add(Object from, Object to) {
        this.nodes.add(from);
        this.nodes.add(to);
        this.edges.add(new Edge(from, to));
        this.notify();
    }

    public synchronized Set<Object> getRootSources() {
        Set<Object> sources = this.getSources();
        Iterator<Object> it = sources.iterator();
        while (it.hasNext()) {
            Object source = it.next();
            if (this.getSourcesFor(source).isEmpty()) continue;
            it.remove();
        }
        return sources;
    }

    public synchronized Set<Object> getSources() {
        LinkedHashSet<Object> nodes = new LinkedHashSet<Object>();
        for (Edge edge : this.edges) {
            nodes.add(edge.getFrom());
        }
        return nodes;
    }

    public synchronized Set<Object> getTargets(Object from) {
        LinkedHashSet<Object> nodes = new LinkedHashSet<Object>();
        for (Edge edge : this.edges) {
            if (edge.getFrom() != from) continue;
            nodes.add(edge.getTo());
        }
        return nodes;
    }

    public synchronized Set<Object> getReferencedObjects() {
        LinkedHashSet<Object> nodes = new LinkedHashSet<Object>();
        for (Edge edge : this.edges) {
            nodes.add(edge.getTo());
        }
        return nodes;
    }

    public synchronized Set<Object> getSourcesFor(Object target) {
        LinkedHashSet<Object> nodes = new LinkedHashSet<Object>();
        for (Edge edge : this.edges) {
            if (edge.getTo() != target) continue;
            nodes.add(edge.getFrom());
        }
        return nodes;
    }

    public synchronized Set<Object> getIsolated() {
        LinkedHashSet<Object> nodes = new LinkedHashSet<Object>();
        for (Object node : this.nodes) {
            if (!this.getSourcesFor(node).isEmpty()) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public synchronized void clear() {
        this.nodes.clear();
        this.edges.clear();
        this.notify();
    }

    public synchronized List<LifeCycle> remove(Object o) {
        if (!this.nodes.contains(o)) {
            return new ArrayList<LifeCycle>();
        }
        List<LifeCycle> objs = this.remove(o, false);
        this.notifyAll();
        return objs;
    }

    private synchronized List<LifeCycle> remove(Object o, boolean notify) {
        log.debug("Removing {} from dependency-graph...", o);
        ArrayList<LifeCycle> lifeObjects = new ArrayList<LifeCycle>();
        if (!this.nodes.contains(o)) {
            return lifeObjects;
        }
        if (o instanceof LifeCycle) {
            lifeObjects.add((LifeCycle)o);
        }
        for (Edge edge : new ArrayList<Edge>(this.edges)) {
            if (edge.getFrom() != o) continue;
            this.nodes.remove(o);
            this.edges.remove(edge);
            Object target = edge.getTo();
            if (this.getSourcesFor(target).isEmpty()) {
                log.debug("[graph-shutdown]     -> No more references to {}, adding to shutdown-queue", target);
                lifeObjects.addAll(this.remove(target, notify));
                continue;
            }
            log.debug("target {} has {} references left", target, (Object)this.getSourcesFor(target).size());
        }
        log.trace("[dep-graph]  Reference counts: ");
        for (Object node : this.nodes) {
            log.trace("[dep-graph]     * {}  is referenced by {} ", node, (Object)this.getSourcesFor(node));
        }
        return lifeObjects;
    }

    public synchronized void printShutdownStrategy() {
        ArrayList<Object> all = new ArrayList<Object>();
        all.addAll(this.nodes);
        LinkedHashSet finished = new LinkedHashSet();
        LinkedBlockingQueue<Object> waiting = new LinkedBlockingQueue<Object>();
        waiting.addAll(this.getIsolated());
        while (!waiting.isEmpty()) {
            Object next = waiting.poll();
            log.trace("[graph-shutdown]   Shutting down {}", next);
            finished.add(next);
            all.remove(next);
        }
        log.trace("[dep-graph]  Reference counts: ");
        for (Object node : this.nodes) {
            log.trace("[dep-graph]     * {}  is referenced by {} objects", node, (Object)this.getSourcesFor(node).size());
        }
    }

    public Collection<Object> getAll(Class<?> pattern) {
        ArrayList<Object> matching = new ArrayList<Object>();
        for (Object o : this.nodes) {
            if (!pattern.isAssignableFrom(o.getClass())) continue;
            matching.add(o);
        }
        return matching;
    }

    @Override
    public void processStarted(Process p) {
        if (this.nodes.contains(p)) {
            log.debug("Process {} started, already part of this graph.", (Object)p);
        } else {
            log.debug("Process {} started, but it is not part of this graph.", (Object)p);
        }
    }

    @Override
    public void processFinished(Process p) {
        log.debug("Process {} finished, removing it from the dependency graph nodes...", (Object)p);
        this.remove(p);
    }

    public static class Edge {
        static Integer lastId = 0;
        final Integer id;
        final Object from;
        final Object to;

        public Edge(Object from, Object to) {
            Integer n = lastId;
            Integer n2 = lastId = Integer.valueOf(lastId + 1);
            this.id = n;
            this.from = from;
            this.to = to;
        }

        public Object getFrom() {
            return this.from;
        }

        public Object getTo() {
            return this.to;
        }
    }
}

