/*
 * Decompiled with CFR 0.152.
 */
package stream.service;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.swing.JComponent;
import javax.swing.JFrame;
import stream.Context;
import stream.runtime.LifeCycle;
import stream.service.DashboardService;

public class Dashboard
implements DashboardService,
LifeCycle {
    protected JFrame frame;
    protected String title = "";
    protected Integer width = 1024;
    protected Integer height = 768;
    final Map<String, JComponent> components = new HashMap<String, JComponent>();

    @Override
    public void reset() throws Exception {
        if (this.frame != null) {
            this.frame.getContentPane().removeAll();
        }
    }

    @Override
    public String addWidget(String id, JComponent widget) {
        String wid = id;
        if (wid == null) {
            wid = UUID.randomUUID().toString().toUpperCase();
        }
        if (this.frame != null) {
            if (this.components.get(wid) != null) {
                JComponent old = this.components.remove(wid);
                this.frame.getContentPane().remove(old);
            }
            this.frame.getContentPane().add(widget);
            this.components.put(wid, widget);
            return wid;
        }
        return null;
    }

    @Override
    public void init(Context context) throws Exception {
        this.frame = new JFrame();
        if (this.title != null) {
            this.frame.setTitle(this.title);
        }
        if (this.width != null && this.height != null) {
            this.frame.setSize(this.width, this.height);
        }
        this.frame.setVisible(true);
    }

    @Override
    public void finish() throws Exception {
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }
}

