/*
 * Decompiled with CFR 0.152.
 */
package stream.statistics;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.Processor;
import stream.annotations.Parameter;
import stream.data.Statistics;
import stream.statistics.StatisticsService;

public class AddStatistics
implements Processor {
    static Logger log = LoggerFactory.getLogger(AddStatistics.class);
    StatisticsService service;
    StatisticsService[] services = new StatisticsService[0];

    public StatisticsService getService() {
        return this.service;
    }

    @Parameter(required=false, description="A statistic service to query")
    public void setService(StatisticsService service) {
        this.service = service;
    }

    public StatisticsService[] getServices() {
        return this.services;
    }

    @Parameter(required=false, description="A list of statistic services to query")
    public void setServices(StatisticsService[] services) {
        this.services = services;
    }

    @Override
    public Data process(Data input) {
        if (this.service != null) {
            Statistics stats = this.service.getStatistics();
            for (String key : stats.keySet()) {
                input.put(key, stats.get(key));
            }
        } else {
            log.error("No statistics service connected!");
        }
        if (this.services != null) {
            for (int i = 0; i < this.services.length; ++i) {
                if (this.services[i] == null) continue;
                Statistics stats = this.services[i].getStatistics();
                for (String key : stats.keySet()) {
                    input.put(key, stats.get(key));
                }
            }
        }
        return input;
    }
}

