/*
 * Decompiled with CFR 0.152.
 */
package stream.storm;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.ProcessContext;

public class BoltContext
implements ProcessContext,
Serializable {
    private static final long serialVersionUID = 6162013508460469957L;
    static Logger log = LoggerFactory.getLogger(BoltContext.class);
    final Map<String, Serializable> values = new LinkedHashMap<String, Serializable>();
    transient Map<String, Object> volatileValues = new LinkedHashMap<String, Object>();

    @Override
    public Object resolve(String variable) {
        if (!variable.startsWith("process.")) {
            log.warn("A BoltContext does currently not provide parent contexts.");
            return null;
        }
        return this.get(variable.substring("process.".length()));
    }

    @Override
    public Object get(String key) {
        if (this.values.containsKey(key)) {
            log.debug("Found serialiable value for key '{}'", (Object)key);
            return this.values.get(key);
        }
        if (this.volatileValues.containsKey(key)) {
            log.debug("Found non-serializable value for key '{}'", (Object)key);
            return this.volatileValues.get(key);
        }
        log.debug("No value for key '{}' stored in this context.", (Object)key);
        return null;
    }

    @Override
    public void set(String key, Object o) {
        if (o instanceof Serializable) {
            this.values.put(key, (Serializable)o);
            this.volatileValues.remove(key);
            return;
        }
        log.warn("Storing non-serializable object in context! The object might be lost during outages!");
        this.values.remove(key);
        this.volatileValues.put(key, o);
    }

    public Object readResolve() {
        if (this.volatileValues == null) {
            this.volatileValues = new LinkedHashMap<String, Object>();
        }
        return this;
    }
}

