/*
 * Decompiled with CFR 0.152.
 */
package stream.storm.config;

import backtype.storm.topology.IRichSpout;
import backtype.storm.topology.SpoutDeclarer;
import backtype.storm.topology.TopologyBuilder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import stream.StreamTopology;
import stream.runtime.setup.ObjectFactory;
import stream.storm.config.ATopologyElementHandler;

public class SpoutHandler
extends ATopologyElementHandler {
    static Logger log = LoggerFactory.getLogger(SpoutHandler.class);

    public SpoutHandler(ObjectFactory of) {
        super(of);
    }

    @Override
    public boolean handles(Element el) {
        if (el == null) {
            return false;
        }
        String name = el.getNodeName();
        return "storm:spout".equalsIgnoreCase(name);
    }

    @Override
    public void handle(Element el, StreamTopology st, TopologyBuilder builder) throws Exception {
        SpoutDeclarer spoutDeclarer;
        if (!this.handles(el)) {
            return;
        }
        String id = el.getAttribute("id");
        if (id == null) {
            throw new Exception("Element '" + el.getNodeName() + "' is missing an 'id' attribute!");
        }
        String className = el.getAttribute("class");
        Map<String, String> params = this.objectFactory.getAttributes(el);
        log.info("  > Found '{}' definition, with class: {}", (Object)el.getNodeName(), (Object)className);
        log.info("  >   Parameters are: {}", (Object)params);
        params = st.getVariables().expandAll(params);
        log.info("  >   Expanded parameters: {}", (Object)params);
        log.info("  >   Creating spout-instance from class {}, parameters: {}", (Object)className, (Object)params);
        IRichSpout bolt = (IRichSpout)this.objectFactory.create(className, params);
        log.info("  > Registering spout '{}' with instance {}", (Object)id, (Object)bolt);
        SpoutDeclarer cur = spoutDeclarer = builder.setSpout(id, bolt);
        st.addSpout(id, cur);
    }
}

