/*
 * Decompiled with CFR 0.152.
 */
package stream.urls;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.io.SourceURL;
import stream.urls.Connection;

public class FIFOConnection
extends Connection {
    static Logger log = LoggerFactory.getLogger(FIFOConnection.class);
    protected InputStream inputStream;

    public FIFOConnection(SourceURL url) {
        super(url);
    }

    @Override
    public String[] getSupportedProtocols() {
        return new String[]{"fifo"};
    }

    @Override
    public InputStream connect() throws IOException {
        try {
            String theUrl = this.url.toString();
            log.debug("Handling FIFO URL pattern...");
            theUrl = theUrl.replace("fifo:", "file:");
            File file = new File(theUrl.replace("file:", ""));
            if (!file.exists()) {
                log.debug("Creating new fifo file '{}' with mkfifo", (Object)file);
                Process p = Runtime.getRuntime().exec("mkfifo " + file.getAbsolutePath());
                log.debug("Waiting for mkfifo to return...");
                int ret = p.waitFor();
                log.debug("mkfifo finished: {}", (Object)ret);
            } else {
                log.debug("Using existing fifo-file '{}'", (Object)file);
            }
            if (!file.exists()) {
                throw new IOException("Failed to create/acquire FIFO file '" + file.getAbsolutePath() + "'!");
            }
            log.debug("Returning FileInputStream for FIFO {}", (Object)file);
            this.inputStream = new FileInputStream(file);
            return this.inputStream;
        }
        catch (Exception e) {
            throw new IOException("Failed to open fifo-queue: " + e.getMessage());
        }
    }

    @Override
    public void disconnect() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }
}

