/*
 * Decompiled with CFR 0.152.
 */
package stream.urls;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import stream.io.SequentialFileInputStream;
import stream.io.SourceURL;
import stream.urls.Connection;

public class FilesConnection
extends Connection {
    protected SequentialFileInputStream seqFileStream;

    public FilesConnection(SourceURL url) {
        super(url);
    }

    @Override
    public String[] getSupportedProtocols() {
        return new String[]{"files"};
    }

    @Override
    public InputStream connect() throws IOException {
        boolean removeAfterRead = "true".equalsIgnoreCase(this.url.getParameters().get("remove"));
        String pattern = ".*";
        if (this.url.getParameters().containsKey("pattern")) {
            pattern = this.url.getParameters().get("pattern");
        }
        File file = new File(this.url.getPath());
        this.seqFileStream = new SequentialFileInputStream(file, pattern, removeAfterRead);
        return this.seqFileStream;
    }

    @Override
    public void disconnect() throws IOException {
        if (this.seqFileStream != null) {
            this.seqFileStream.close();
            this.seqFileStream = null;
        }
    }
}

