/*
 * Decompiled with CFR 0.152.
 */
package stream.urls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.io.SourceURL;
import stream.urls.TcpConnection;

public class SSLConnection
extends TcpConnection {
    static Logger log = LoggerFactory.getLogger(SSLConnection.class);
    KeyStore keyStore;
    KeyStore trustStore;
    private char[] password;
    protected final String host;
    protected final int port;
    protected SSLContext ssl;
    protected SSLSocket socket;
    private InputStream inputStream;
    private OutputStream outputStream;

    public SSLConnection(SourceURL url) throws Exception {
        super(url);
        this.host = url.getHost();
        this.port = url.getPort();
        this.password = (char[])(url.getParameters().containsKey("keystorePassword") ? url.getParameters().get("keystorePassword").toCharArray() : null);
        if (url.getParameters().containsKey("keystoreUrl")) {
            URL ksUrl = new URL(url.getParameters().get("keystoreUrl"));
            this.loadKeyStore(ksUrl, this.password);
        } else {
            this.keyStore = null;
        }
        if (url.getParameters().containsKey("truststoreUrl")) {
            this.trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            URL tsUrl = new URL(url.getParameters().get("truststoreUrl"));
            String trustpw = url.getParameters().get("truststorePassword");
            if (trustpw == null) {
                trustpw = new String(this.password);
            }
            this.loadTrustStore(tsUrl, trustpw.toCharArray());
        } else {
            this.trustStore = this.keyStore;
        }
    }

    public void setKeyStore(KeyStore ks, char[] password) {
        this.keyStore = ks;
        this.password = password;
    }

    public void loadKeyStore(URL url, char[] password) throws Exception {
        this.keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        this.keyStore.load(url.openStream(), password);
        this.password = password;
    }

    public void setTrustStore(KeyStore ks, char[] password) {
        this.trustStore = ks;
        this.password = password;
    }

    public void loadTrustStore(URL url, char[] password) throws Exception {
        this.trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        this.trustStore.load(url.openStream(), password);
    }

    public void open() throws Exception {
        SSLSocketFactory factory;
        if (this.keyStore == null && this.password == null) {
            log.debug("No KeyStore/password specified, using default keys/trust-store.");
            factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        } else {
            log.debug("Specific keystore specified, creating custom SSL context...");
            KeyManagerFactory kmf = this.getKeyManagerFactory();
            log.info("Initializing key manager factory with keyStore {} and password {}", (Object)this.keyStore, (Object)this.password);
            kmf.init(this.keyStore, this.password);
            TrustManagerFactory tmf = this.getTrustManagerFactory();
            log.info("Initializing trust manager factory with trustStore {}", (Object)this.trustStore);
            tmf.init(this.trustStore);
            this.ssl = SSLContext.getInstance("TLS");
            log.info("Created SSL context {}", (Object)this.ssl);
            this.ssl.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            factory = this.ssl.getSocketFactory();
        }
        this.socket = (SSLSocket)factory.createSocket(this.host, this.port);
        this.inputStream = this.socket.getInputStream();
        this.outputStream = this.socket.getOutputStream();
    }

    public void close() throws Exception {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    protected KeyManagerFactory getKeyManagerFactory() throws NoSuchAlgorithmException {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        return kmf;
    }

    protected TrustManagerFactory getTrustManagerFactory() throws NoSuchAlgorithmException {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        return tmf;
    }

    @Override
    public InputStream connect() throws IOException {
        if (this.socket != null && this.socket.isConnected() && this.inputStream != null) {
            log.debug("Connection already established...");
            return this.inputStream;
        }
        try {
            this.open();
            return this.socket.getInputStream();
        }
        catch (Exception e) {
            log.error("Failed to connect: {}", (Object)e.getMessage());
            e.printStackTrace();
            throw new IOException("Failed to connect: " + e.getMessage());
        }
    }

    @Override
    public void disconnect() throws IOException {
        try {
            this.close();
        }
        catch (Exception e) {
            log.error("Failed to disconnect: {}", (Object)e.getMessage());
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new IOException("Failed to disconnect: " + e.getMessage());
        }
        finally {
            this.inputStream = null;
            this.outputStream = null;
        }
    }

    @Override
    public String[] getSupportedProtocols() {
        return new String[]{"ssl"};
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }
}

