/*
 * Decompiled with CFR 0.152.
 */
package stream.urls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.io.SourceURL;
import stream.urls.Connection;

public class TcpConnection
extends Connection {
    static Logger log = LoggerFactory.getLogger(TcpConnection.class);
    public static final String PARAM_RECONNECT = "reconnect";
    public static final String PARAM_RECONNECT_INTERVAL = "reconnectInterval";
    protected Socket connect;
    protected final String host;
    protected final Integer port;

    public TcpConnection(SourceURL url) {
        super(url);
        this.host = url.getHost();
        this.port = url.getPort();
    }

    @Override
    public InputStream connect() throws IOException {
        try {
            log.debug("Connecting via TCP to {}:{}", (Object)this.host, (Object)this.port);
            this.connect = new Socket(this.host, (int)this.port);
            return this.connect.getInputStream();
        }
        catch (IOException e) {
            log.error("Connection failed: {}", (Object)e.getMessage());
            throw e;
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.connect == null) {
            this.connect();
        }
        if (this.connect == null) {
            log.error("Tried to access input-stream but no connection has been established, yet!");
            throw new IOException("TcpURLConnection not yet established!");
        }
        log.debug("Returning input-stream for TCP connection {}", (Object)this.connect);
        return this.connect.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.connect == null || !this.connect.isConnected()) {
            log.error("Tried to access output-stream but no connection has been established, yet!");
            throw new IOException("TcpURLConnectio not yet established!");
        }
        log.debug("Returning output-stream for TCP connection {}", (Object)this.connect);
        return this.connect.getOutputStream();
    }

    public String toString() {
        return "TcpConnection(" + super.toString() + ")[" + this.host + ":" + this.port + "]";
    }

    @Override
    public String[] getSupportedProtocols() {
        return new String[]{"tcp"};
    }

    @Override
    public void disconnect() throws IOException {
        if (this.connect != null) {
            this.connect.close();
        }
    }
}

