/*
 * Decompiled with CFR 0.152.
 */
package stream.util;

import java.io.Serializable;
import stream.util.parser.ByteSizeParser;

public class ByteSize
implements Serializable {
    private static final long serialVersionUID = -2170050360625001698L;
    final Integer bytes;

    public ByteSize(Integer bytes) throws Exception {
        this.bytes = bytes;
        if (bytes < 0) {
            throw new Exception("ByteSizes must not be negative!");
        }
    }

    public ByteSize(String val) throws Exception {
        Long bs = ByteSizeParser.parseByteSize(val);
        this.bytes = bs.intValue();
    }

    public int getBytes() {
        return this.bytes;
    }

    public int getKilobyte() {
        return this.bytes / 1024;
    }

    public int getMegabyte() {
        return this.getKilobyte() / 1024;
    }

    public int getGigabyte() {
        return this.getMegabyte() / 1024;
    }

    public int getPetabyte() {
        return this.getGigabyte() / 1024;
    }
}

