/*
 * Decompiled with CFR 0.152.
 */
package stream.util;

import java.lang.reflect.Modifier;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Processor;
import stream.annotations.Internal;
import stream.io.Stream;
import stream.util.ClassFinder;

public class DocFinder {
    static Logger log = LoggerFactory.getLogger(DocFinder.class);
    public static final Class<?>[] CLASSES = new Class[]{Processor.class, Stream.class};

    public static void main(String[] args) throws Exception {
        Class<?>[] classes = ClassFinder.getClasses("");
        TreeSet<String> docs = new TreeSet<String>();
        TreeSet<String> missing = new TreeSet<String>();
        block0: for (Class<?> clazz : classes) {
            if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) continue;
            if (clazz.isAnnotationPresent(Internal.class)) {
                System.out.println("Skipping internal class " + clazz);
                continue;
            }
            for (Class<?> apiClass : CLASSES) {
                if (!apiClass.isAssignableFrom(clazz)) continue;
                if (clazz.isAnnotationPresent(Deprecated.class)) {
                    System.out.println("Skipping deprecated class " + clazz);
                    continue block0;
                }
                log.debug("Found processor-class {}", (Object)clazz);
                log.debug("    clazz.getName() = {}", (Object)clazz.getName());
                String doc = "/" + clazz.getName().replace('.', '/') + ".md";
                log.debug("    docs are at {}", (Object)doc);
                URL url = DocFinder.class.getResource(doc);
                if (url != null) {
                    docs.add(doc);
                    continue;
                }
                missing.add(doc);
                log.error("No documentation provided for class {}", (Object)clazz);
            }
        }
        for (String doc : docs) {
            System.out.println("   " + doc);
        }
        System.out.println("");
        System.out.println("Missing documentation:");
        for (String doc : missing) {
            System.out.println("   " + doc);
        }
        Integer total = missing.size() + docs.size();
        Integer complete = docs.size();
        DecimalFormat fmt = new DecimalFormat("0.00%");
        System.out.println("Documentation completness is " + fmt.format(complete.doubleValue() / total.doubleValue()));
    }
}

