/*
 * Decompiled with CFR 0.152.
 */
package stream.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.io.Serializer;

public class JavaSerializer
implements Serializer {
    static final Logger log = LoggerFactory.getLogger(JavaSerializer.class);

    @Override
    public Serializable clone(Serializable object) throws Exception {
        if (object == null) {
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.write(object, baos);
            baos.flush();
            baos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            Serializable value = this.read(bais);
            bais.close();
            return value;
        }
        catch (Exception e) {
            log.error("Cloning object {} failed: {}", (Object)object, (Object)e.getMessage());
            throw new Exception(e.getMessage());
        }
    }

    @Override
    public Serializable read(InputStream in) throws IOException {
        try {
            ObjectInputStream ois = new ObjectInputStream(in);
            Serializable value = (Serializable)ois.readObject();
            return value;
        }
        catch (Exception e) {
            log.error("De-serialization of object from input-stream {} failed: {}", (Object)in, (Object)e.getMessage());
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void write(Serializable object, OutputStream out) throws IOException {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(object);
            oos.flush();
        }
        catch (Exception e) {
            log.error("Serialization of object {} failed: {}", (Object)object, (Object)e.getMessage());
            throw new IOException(e.getMessage());
        }
    }
}

