/*
 * Decompiled with CFR 0.152.
 */
package stream.util;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import stream.Measurable;

public class SizeOf {
    public static final Map<Class<?>, Double> basicSizes = new HashMap();

    public static double sizeOf(Object o) {
        Class<?> clazz = o.getClass();
        if (basicSizes.containsKey(clazz)) {
            return basicSizes.get(clazz);
        }
        if (o.getClass().isArray() && basicSizes.containsKey(clazz.getComponentType())) {
            return (double)Array.getLength(o) * basicSizes.get(clazz.getComponentType());
        }
        if (o instanceof String) {
            String str = (String)o;
            return str.getBytes().length;
        }
        if (o instanceof Measurable) {
            return ((Measurable)o).getByteSize();
        }
        if (o instanceof Serializable) {
            return SizeOf.sizeOf((Serializable)o);
        }
        return Double.NaN;
    }

    private static double sizeOf(Serializable o) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            oos.close();
            return baos.size();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Double.NaN;
        }
    }

    static {
        basicSizes.put(Integer.TYPE, 4.0);
        basicSizes.put(Integer.class, 4.0);
        basicSizes.put(Long.TYPE, 8.0);
        basicSizes.put(Long.class, 8.0);
        basicSizes.put(Double.TYPE, 8.0);
        basicSizes.put(Double.class, 8.0);
        basicSizes.put(Character.TYPE, 2.0);
        basicSizes.put(Character.class, 2.0);
    }
}

