/*
 * Decompiled with CFR 0.152.
 */
package stream.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;

public class URLUtilities {
    public static String readContentOrEmpty(URL url) {
        try {
            return URLUtilities.readContent(url);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String readContent(URL url) throws IOException {
        if (url == null) {
            return "";
        }
        return URLUtilities.readResponse(url.openStream());
    }

    public static String readResponse(InputStream in) throws IOException {
        StringBuffer s = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String line = reader.readLine();
        while (line != null) {
            s.append(line + "\n");
            line = reader.readLine();
        }
        reader.close();
        return s.toString();
    }

    public static void copy(URL url, OutputStream out) throws IOException {
        if (url == null) {
            return;
        }
        InputStream in = url.openStream();
        byte[] buf = new byte[1024];
        int read = in.read(buf);
        while (read > 0) {
            out.write(buf, 0, read);
            read = in.read(buf);
        }
        in.close();
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[1024];
        int read = in.read(buf);
        while (read > 0) {
            out.write(buf, 0, read);
            read = in.read(buf);
        }
        in.close();
    }

    public static void copy(URL url, File file) throws IOException {
        if (url == null) {
            return;
        }
        FileOutputStream fos = new FileOutputStream(file);
        URLUtilities.copy(url, (OutputStream)fos);
        fos.flush();
        ((OutputStream)fos).close();
    }
}

