/*
 * Decompiled with CFR 0.152.
 */
package stream.util.parser;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteSizeParser {
    static Logger log = LoggerFactory.getLogger(ByteSizeParser.class);
    static Map<String, Long> UNITS = new LinkedHashMap<String, Long>();
    public static final Long BYTE = 1L;
    public static final Long KILOBYTE = 1024L * BYTE;
    public static final Long MEGABYTE = 1024L * KILOBYTE;
    public static final Long GIGABYTE = 1024L * MEGABYTE;
    public static final Long PETABYTE = 1024L * GIGABYTE;

    public static Long parseByteSize(String str) throws Exception {
        long time = 0L;
        String s = str.trim();
        while (s.length() > 0) {
            String[] tok = ByteSizeParser.readInteger(s);
            Integer i = new Integer(tok[0]);
            s = tok[1].trim();
            String unit = (tok = ByteSizeParser.readUnit(s))[0];
            List<String> uk = ByteSizeParser.findUnits(unit);
            if (uk.size() == 1) {
                unit = uk.get(0);
                log.debug("integer i = " + i + ",  unit = " + unit);
            } else {
                if (uk.isEmpty()) {
                    uk.add("b");
                }
                if (uk.size() > 1) {
                    throw new Exception("Ambiguous time-unit '" + unit + "' found!");
                }
            }
            Long ms = UNITS.get(unit);
            time += (long)i.intValue() * ms;
            s = tok[1].trim();
        }
        return time;
    }

    public static String[] readInteger(String str) {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < str.length() && ByteSizeParser.isDigit(str, i)) {
            s.append(str.charAt(i++));
        }
        return new String[]{s.toString(), str.substring(i).trim()};
    }

    public static String[] readUnit(String str) {
        if (str.trim().isEmpty()) {
            return new String[]{"b", ""};
        }
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < str.length() & ByteSizeParser.isUnitChar(str, i)) {
            s.append(str.charAt(i++));
        }
        return new String[]{s.toString(), str.substring(i)};
    }

    public static boolean isDigit(String str, int i) {
        if (i >= 0 && i < str.length()) {
            char ch = str.charAt(i);
            return Character.isDigit(ch);
        }
        return false;
    }

    public static boolean isUnitChar(String str, int i) {
        if (i >= 0 && i < str.length()) {
            char ch = str.charAt(i);
            return Character.isLetter(ch);
        }
        return false;
    }

    public static List<String> findUnits(String str) {
        LinkedList<String> units = new LinkedList<String>();
        for (String key : UNITS.keySet()) {
            if (!key.startsWith(str.toLowerCase())) continue;
            units.add(key);
        }
        log.debug("Units: {}", (Object)units);
        return units;
    }

    static {
        UNITS.put("b", BYTE);
        UNITS.put("kb", KILOBYTE);
        UNITS.put("mb", MEGABYTE);
        UNITS.put("gb", GIGABYTE);
        UNITS.put("pb", PETABYTE);
    }
}

