/*
 * Decompiled with CFR 0.152.
 */
package stream.util.parser;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.util.parser.MParser;
import stream.util.parser.ParseException;
import stream.util.parser.Parser;
import stream.util.parser.Token;

public class GenericTurboParser
extends MParser
implements Parser<Map<String, String>> {
    static Logger log = LoggerFactory.getLogger(GenericTurboParser.class);
    Token[] tokens;
    Map<String, String> defaults = new LinkedHashMap<String, String>();

    public GenericTurboParser(List<Token> token) {
        this.tokens = token.toArray(new Token[token.size()]);
    }

    @Override
    public Map<String, String> parse(String str) throws ParseException {
        int i;
        this.pos = 0;
        LinkedHashMap<String, String> reads = new LinkedHashMap<String, String>();
        if (this.tokens.length < 1) {
            return reads;
        }
        Token token = this.tokens[0];
        Token next = null;
        String[] values = new String[this.tokens.length];
        int cur = 0;
        for (i = 1; i < this.tokens.length + 1; ++i) {
            next = i != this.tokens.length ? this.tokens[i] : null;
            if (token.isVariable) {
                int idx;
                if (next == null) {
                    if (this.pos >= 0 && this.pos < str.length()) {
                        values[cur] = str.substring(this.pos);
                        break;
                    }
                    values[cur] = "";
                    break;
                }
                if (next.isVariable) {
                    idx = str.indexOf(next.value, this.pos);
                    if (idx >= 0) {
                        values[cur] = str.substring(idx + next.length);
                    }
                } else {
                    idx = str.indexOf(next.value, this.pos);
                    if (idx < 0) {
                        idx = str.length();
                    }
                    values[cur] = str.substring(this.pos, idx);
                    this.pos = idx;
                }
            } else {
                this.pos += token.length;
                values[cur] = null;
            }
            token = next;
            ++cur;
        }
        for (i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            reads.put(this.tokens[i].name, values[i]);
        }
        return reads;
    }

    @Override
    public Map<String, String> getDefaults() {
        return this.defaults;
    }

    @Override
    public void setDefaults(Map<String, String> defaults) {
        this.defaults.clear();
        this.defaults.putAll(defaults);
    }
}

