/*
 * Decompiled with CFR 0.152.
 */
package stream.util.parser;

import java.util.LinkedHashMap;
import java.util.LinkedList;

public class MParser {
    int pos = 0;
    static String line = "66.249.65.43 - - [22/Nov/2009:18:39:12 +0100]  \"GET /web/policy/editor.jsp HTTP/1.1\" 200 6065 \"-\" \"Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)\"";

    public void reset() {
        this.pos = 0;
    }

    public void skip(int i) {
        this.pos += i;
    }

    public void skipBlanks(String str) {
        while (this.pos < str.length() && Character.isWhitespace(str.charAt(this.pos))) {
            ++this.pos;
        }
    }

    public int position() {
        return this.pos;
    }

    public String remainder(String str) {
        if (this.pos < 0) {
            return "";
        }
        if (this.pos >= 0 && this.pos < str.length()) {
            return str.substring(this.pos);
        }
        return "";
    }

    public Character firstChar(String str) {
        if (this.pos >= 0 && this.pos < str.length()) {
            return Character.valueOf(str.charAt(this.pos));
        }
        return null;
    }

    public String prefix(String str, int len) {
        StringBuffer s = new StringBuffer();
        int i = this.pos;
        while (i < str.length() && i < this.pos + len) {
            s.append(str.charAt(i++));
        }
        return s.toString();
    }

    public String readToken(String str) {
        Pair<String, Integer> tok = MParser.readToken(str, this.pos);
        this.pos = (Integer)tok.value;
        return (String)tok.key;
    }

    public String readTokenUntil(String str, String prefix) {
        Pair<String, Integer> tok = MParser.readToken(str, this.pos, prefix);
        this.pos = (Integer)tok.value;
        return (String)tok.key;
    }

    public String readToken(String str, char open, char close) {
        Pair<String, Integer> tok = MParser.readToken(str, this.pos, open, close);
        this.pos = (Integer)tok.value;
        return (String)tok.key;
    }

    public Integer readInteger(String str) {
        this.skipBlanks(str);
        StringBuffer s = new StringBuffer();
        while (this.pos < str.length() && Character.isDigit(str.charAt(this.pos))) {
            s.append(str.charAt(this.pos));
            ++this.pos;
        }
        return new Integer(s.toString());
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static Pair<String, Integer> readToken(String str, int offset) {
        int end;
        int start = offset;
        if (start >= str.length()) {
            return new Pair<String, Integer>("", str.length());
        }
        while (start < str.length() && Character.isWhitespace(str.charAt(start))) {
            ++start;
        }
        if (str.charAt(start) == '\"') {
            return MParser.readToken(str, start, '\"', '\"');
        }
        if (str.charAt(start) == '(') {
            return MParser.readToken(str, start, '(', ')');
        }
        if (str.charAt(start) == '[') {
            return MParser.readToken(str, start, '[', ']');
        }
        for (end = start; end < str.length() && str.charAt(end) != ' '; ++end) {
        }
        return new Pair<String, Integer>(str.substring(start, end), end);
    }

    public static Pair<String, Integer> readToken(String str, int offset, String boundary) {
        int end;
        int start = offset;
        if (start >= str.length()) {
            return new Pair<String, Integer>("", str.length());
        }
        while (start < str.length() && Character.isWhitespace(str.charAt(start))) {
            ++start;
        }
        if (str.charAt(start) == '\"') {
            return MParser.readToken(str, start, '\"', '\"');
        }
        if (str.charAt(start) == '(') {
            return MParser.readToken(str, start, '(', ')');
        }
        if (str.charAt(start) == '[') {
            return MParser.readToken(str, start, '[', ']');
        }
        for (end = start; end < str.length() && !str.startsWith(boundary, end); ++end) {
        }
        return new Pair<String, Integer>(str.substring(start, end), end);
    }

    public static Pair<String, Integer> readToken(String str, int offset, char opening, char closing) {
        int start;
        for (start = offset; start < str.length() && str.charAt(start) != opening; ++start) {
        }
        if (str.charAt(start) == opening) {
            int i;
            for (i = start + 1; i < str.length() && str.charAt(i) != closing; ++i) {
            }
            if (i + 1 < str.length()) {
                ++i;
            }
            return new Pair<String, Integer>(str.substring(start, i), i);
        }
        return new Pair<String, Integer>("", offset);
    }

    public static String trim(String str, String tr) {
        if (str.startsWith(tr) && str.endsWith(tr)) {
            return str.substring(tr.length(), str.length() - 2 * tr.length());
        }
        return str;
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().equals("");
    }

    public static void main(String[] args) throws Exception {
        String str = line;
        LinkedList<String> tokens = new LinkedList<String>();
        MParser p = new MParser();
        tokens.add(p.readToken(str));
        tokens.add(p.readToken(str));
        tokens.add(p.readToken(str));
        tokens.add(p.readToken(str));
        String tok = p.readToken(str);
        while (tok != null && !tok.equals("")) {
            tokens.add(tok);
            tok = p.readToken(str);
        }
        System.out.println("----------------------------------------------------");
        System.out.println();
        int i = 0;
        for (String s : tokens) {
            System.out.println("   token[" + i + "]: " + s);
            ++i;
        }
        System.out.println();
        System.out.println("----------------------------------------------------");
        System.out.println();
        System.out.println();
        p.reset();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        p.reset();
        map.put("REMOTE_ADDR", p.readToken(str));
        map.put("REMOTE_USER", p.readToken(str));
        map.put("__UNKNOWN__", p.readToken(str));
        map.put("DATE", p.readToken(str, '[', ']'));
        map.put("REQUEST_LINE", p.readToken(str));
        map.put("RESPONSE_STATUS", p.readToken(str));
        map.put("RESPONSE_SIZE", p.readToken(str));
        map.put("REFERER", p.readToken(str));
        map.put("USER_AGENT", p.readToken(str));
        for (String key : map.keySet()) {
            System.out.println("  " + key + "  => " + (String)map.get(key));
        }
    }

    public static class Pair<K, V> {
        public final K key;
        public final V value;

        public Pair(K key, V val) {
            this.key = key;
            this.value = val;
        }
    }
}

