/*
 * Decompiled with CFR 0.152.
 */
package stream.util.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.util.parser.GenericTurboParser;
import stream.util.parser.ParseException;
import stream.util.parser.Parser;
import stream.util.parser.Token;

public class ParserGenerator {
    static Logger log = LoggerFactory.getLogger(ParserGenerator.class);
    String grammar;

    public ParserGenerator(String grammar) {
        this.grammar = grammar;
    }

    public Map<String, String> parse(String str) throws ParseException {
        return this.newParser().parse(str);
    }

    public Parser<Map<String, String>> newParser() {
        return this.create(this.grammar);
    }

    public List<String> parseGrammar(String grammar) {
        ArrayList<String> toks = new ArrayList<String>();
        int off = 0;
        for (int i = 0; i < grammar.length(); ++i) {
            log.debug("Parsing grammar: '{}'", (Object)grammar.substring(i));
            if (grammar.startsWith("%(", i)) {
                int end;
                if (i > off) {
                    String con = grammar.substring(off, i);
                    log.debug("adding constant {}", (Object)con);
                    toks.add(con);
                }
                if ((end = grammar.indexOf(")", i + 1)) < i) continue;
                String var = grammar.substring(i, end + 1);
                log.debug("Found variable {}", (Object)var);
                toks.add(var);
                off = end + 1;
                i += var.length() - 1;
                continue;
            }
            if (grammar.indexOf("%(", i) >= 0) continue;
            log.debug("Found no more variables, treating remainder string as constant token!");
            toks.add(grammar.substring(i));
            return toks;
        }
        return toks;
    }

    public Parser<Map<String, String>> create(String grammarDefinition) {
        ArrayList<Token> tokenDefs = new ArrayList<Token>();
        List<String> tokens = this.parseGrammar(grammarDefinition);
        log.debug("Grammar tokens: {}", (Object)tokens);
        for (String toks : tokens) {
            tokenDefs.add(new Token(toks));
        }
        return new GenericTurboParser(tokenDefs);
    }

    public static List<Token> readGrammar(String grammarDefinition) {
        ArrayList<Token> tokenDefs = new ArrayList<Token>();
        List<String> tokens = new ParserGenerator(grammarDefinition).parseGrammar(grammarDefinition);
        log.debug("Grammar tokens: {}", (Object)tokens);
        for (String toks : tokens) {
            tokenDefs.add(new Token(toks));
        }
        return tokenDefs;
    }

    public boolean isVariableToken(String str) {
        boolean var = str != null && str.startsWith("%(") && str.endsWith(")");
        log.debug("isVariableToken( {} ) = {} ", (Object)str, (Object)var);
        return var;
    }

    public static String stripMacroName(String name) {
        if (name.startsWith("%(") && name.endsWith(")")) {
            int len = name.length();
            return name.substring(2, len - 1);
        }
        return name;
    }
}

