/*
 * Decompiled with CFR 0.152.
 */
package stream.util.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.util.parser.ParserGenerator;

public class Token {
    static Logger log = LoggerFactory.getLogger(Token.class);
    static final String TOKEN_START = "%(";
    static final String TOKEN_END = ")";
    public final boolean isVariable;
    public final String name;
    public final String value;
    public final int length;
    public final Pattern pattern;

    public Token(String name) {
        this.value = name;
        this.isVariable = this.value != null && this.value.startsWith(TOKEN_START) && this.value.endsWith(TOKEN_END);
        this.name = this.isVariable ? ParserGenerator.stripMacroName(name) : null;
        this.length = this.value.length();
        if (!name.startsWith(TOKEN_START)) {
            Pattern p;
            try {
                log.debug("trying to treat '{}' as regular expression", (Object)name);
                p = Pattern.compile(name);
            }
            catch (Exception e) {
                p = null;
            }
            this.pattern = p;
        } else {
            Pattern p = null;
            try {
                int idx = name.indexOf("|");
                int end = name.lastIndexOf(TOKEN_END);
                if (idx >= 0 && end > idx) {
                    p = Pattern.compile(name.substring(idx + 1, end));
                }
                log.debug("Created regex-token with regex = '{}'", (Object)p);
            }
            catch (Exception e) {
                log.debug("Failed to compile pattern: {}", (Object)e.getMessage());
                if (log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                p = null;
            }
            this.pattern = p;
        }
    }

    public boolean isRegex() {
        return this.pattern != null;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean isVariable() {
        return this.isVariable;
    }

    public String getName() {
        if (this.isVariable()) {
            String str = this.value.substring(2, this.value.length() - 1);
            if (str.indexOf("|") > 0) {
                return str.substring(0, str.indexOf("|"));
            }
            return str;
        }
        return this.value;
    }

    public int skipLength(String str) {
        if (this.isRegex()) {
            log.debug("Checking skip-length for pattern '{}' on string {}", (Object)this.pattern.toString(), (Object)str);
            Matcher matcher = this.pattern.matcher(str);
            if (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                log.debug("checking string '{}'", (Object)str);
                String val = str.substring(start, end);
                log.debug("substring '{}' matches {}", (Object)val, (Object)this.pattern);
                return val.length();
            }
        }
        return this.length;
    }

    public String getValue() {
        return this.value;
    }
}

