/*
 * Decompiled with CFR 0.152.
 */
package stream.storm;

import backtype.storm.spout.SpoutOutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseRichSpout;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Values;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.io.Stream;
import stream.runtime.Variables;
import stream.runtime.setup.StreamFactory;

public class StreamSpout
extends BaseRichSpout {
    private static final long serialVersionUID = -786482575770711600L;
    static Logger log = LoggerFactory.getLogger(StreamSpout.class);
    transient Stream stream;
    protected SpoutOutputCollector output;
    protected final String className;
    protected final Variables parameters;

    public StreamSpout(String className, Map<String, String> params) {
        log.debug("Creating spout for stream (class: {}, params: {})", (Object)className, params);
        this.className = className;
        this.parameters = new Variables(params);
    }

    public void open(Map conf, TopologyContext context, SpoutOutputCollector collector) {
        this.output = collector;
        try {
            HashMap params = new HashMap(this.parameters);
            log.info("Creating stream for class: {}, params: {}", (Object)this.className, params);
            this.stream = StreamFactory.createStream((String)this.className, params);
            this.stream.init();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to open stream: " + e.getMessage());
        }
    }

    public void nextTuple() {
        block3: {
            log.debug("nextTuple() called");
            try {
                Data item = this.stream.read();
                log.debug("read item: {}", (Object)item);
                if (item != null) {
                    log.debug("Emitting item as tuple...");
                    this.output.emit((List)new Values(new Object[]{item}));
                }
            }
            catch (Exception e) {
                log.error("Failed to read next item: {}", (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block3;
                e.printStackTrace();
            }
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        log.debug("Declaring output-field 'stream.Data'");
        declarer.declare(new Fields(new String[]{"stream.Data"}));
    }
}

