/*
 * Decompiled with CFR 0.152.
 */
package stream.storm.config;

import backtype.storm.topology.BoltDeclarer;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.TopologyBuilder;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import stream.StreamTopology;
import stream.runtime.setup.ObjectFactory;
import stream.storm.config.ATopologyElementHandler;

public class BoltHandler
extends ATopologyElementHandler {
    static Logger log = LoggerFactory.getLogger(BoltHandler.class);

    public BoltHandler(ObjectFactory of) {
        super(of);
    }

    @Override
    public boolean handles(Element el) {
        String name = el.getNodeName();
        return name.equalsIgnoreCase("storm:bolt");
    }

    @Override
    public void handle(Element el, StreamTopology st, TopologyBuilder builder) throws Exception {
        BoltDeclarer boltDeclarer;
        if (!this.handles(el)) {
            return;
        }
        String id = el.getAttribute("id");
        if (id == null) {
            throw new Exception("Element '" + el.getNodeName() + "' is missing an 'id' attribute!");
        }
        String className = el.getAttribute("class");
        Map params = this.objectFactory.getAttributes((Node)el);
        log.info("  > Found '{}' definition, with class: {}", (Object)el.getNodeName(), (Object)className);
        log.info("  >   Parameters are: {}", (Object)params);
        params = st.getVariables().expandAll(params);
        log.info("  >   Expanded parameters: {}", (Object)params);
        log.info("  >   Creating bolt-instance from class {}, parameters: {}", (Object)className, (Object)params);
        IRichBolt bolt = (IRichBolt)this.objectFactory.create(className, params);
        log.info("  > Registering bolt '{}' with instance {}", (Object)id, (Object)bolt);
        BoltDeclarer cur = boltDeclarer = builder.setBolt(id, bolt);
        List<String> inputs = this.getInputNames(el);
        if (!inputs.isEmpty()) {
            for (String input : inputs) {
                if (input.isEmpty()) continue;
                log.info("  > Connecting bolt '{}' to shuffle-group '{}'", (Object)id, (Object)input);
                cur = (BoltDeclarer)cur.shuffleGrouping(input);
            }
        } else {
            log.debug("No inputs defined for bolt '{}'!", (Object)id);
        }
        st.addBolt(id, cur);
    }
}

