/*
 * Decompiled with CFR 0.152.
 */
package stream;

import backtype.storm.Config;
import backtype.storm.StormSubmitter;
import backtype.storm.generated.StormTopology;
import backtype.storm.topology.BoltDeclarer;
import backtype.storm.topology.SpoutDeclarer;
import backtype.storm.topology.TopologyBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import stream.DocumentEncoder;
import stream.runtime.Variables;
import stream.runtime.setup.ObjectFactory;
import stream.runtime.setup.handler.PropertiesHandler;
import stream.storm.config.ATopologyElementHandler;
import stream.storm.config.BoltHandler;
import stream.storm.config.ConfigHandler;
import stream.storm.config.ProcessHandler;
import stream.storm.config.SpoutHandler;
import stream.storm.config.StreamHandler;
import stream.util.XMLUtils;

public class StreamTopology {
    public static final String UUID_ATTRIBUTE = "stream.storm.uuid";
    static Logger log = LoggerFactory.getLogger(StreamTopology.class);
    public final TopologyBuilder builder;
    public final Map<String, BoltDeclarer> bolts = new LinkedHashMap<String, BoltDeclarer>();
    public final Map<String, SpoutDeclarer> spouts = new LinkedHashMap<String, SpoutDeclarer>();
    public final Variables variables = new Variables();

    private StreamTopology(TopologyBuilder builder) {
        this.builder = builder;
    }

    public TopologyBuilder getTopologyBuilder() {
        return this.builder;
    }

    public Variables getVariables() {
        return this.variables;
    }

    public Map<String, BoltDeclarer> getBolts() {
        return Collections.unmodifiableMap(this.bolts);
    }

    public Map<String, SpoutDeclarer> getSpouts() {
        return Collections.unmodifiableMap(this.spouts);
    }

    public static StreamTopology create(Document doc) throws Exception {
        return StreamTopology.build(doc, new TopologyBuilder());
    }

    public static StreamTopology build(Document doc, TopologyBuilder builder) throws Exception {
        StreamTopology st = new StreamTopology(builder);
        doc = XMLUtils.addUUIDAttributes((Document)doc, (String)UUID_ATTRIBUTE);
        String xml = XMLUtils.toString((Document)doc);
        ObjectFactory of = ObjectFactory.newInstance();
        try {
            PropertiesHandler handler = new PropertiesHandler();
            handler.handle(null, doc, st.getVariables());
            log.info("########################################################################");
            log.info("Found properties: {}", (Object)st.getVariables());
            for (String key : st.getVariables().keySet()) {
                log.info("   '{}' = '{}'", (Object)key, (Object)st.getVariables().get(key));
            }
            log.info("########################################################################");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        ArrayList<ATopologyElementHandler> handlers = new ArrayList<ATopologyElementHandler>();
        handlers.add(new SpoutHandler(of));
        handlers.add(new StreamHandler(of, xml));
        handlers.add(new BoltHandler(of));
        handlers.add(new ProcessHandler(of, xml));
        NodeList list = doc.getDocumentElement().getChildNodes();
        for (ConfigHandler configHandler : handlers) {
            for (int i = 0; i < list.getLength(); ++i) {
                Element el;
                Node node = list.item(i);
                if (node.getNodeType() != 1 || !configHandler.handles(el = (Element)node)) continue;
                log.info("--------------------------------------------------------------------------------");
                log.info("Handling element '{}'", (Object)node.getNodeName());
                configHandler.handle(el, st, builder);
                log.info("--------------------------------------------------------------------------------");
            }
        }
        return st;
    }

    public void addBolt(String id, BoltDeclarer bolt) {
        this.bolts.put(id, bolt);
    }

    public void addSpout(String id, SpoutDeclarer spout) {
        this.spouts.put(id, spout);
    }

    protected static List<String> getInputNames(Element el) {
        ArrayList<String> inputs = new ArrayList<String>();
        String input = el.getAttribute("input");
        if (input == null) {
            return inputs;
        }
        if (input.indexOf(",") < 0) {
            inputs.add(input.trim());
            return inputs;
        }
        for (String in : input.split(",")) {
            if (in == null || in.trim().isEmpty()) continue;
            inputs.add(in.trim());
        }
        return inputs;
    }

    public StormTopology createTopology() {
        return this.builder.createTopology();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Missing XML definition (base64 encoded)!");
            return;
        }
        Document doc = DocumentEncoder.decodeDocument(args[0]);
        Config conf = new Config();
        conf.setNumWorkers(20);
        StreamTopology streamTop = StreamTopology.build(doc, new TopologyBuilder());
        StormTopology topology = streamTop.getTopologyBuilder().createTopology();
        StormSubmitter.submitTopology((String)"test", (Map)conf, (StormTopology)topology);
    }
}

