/*
 * Decompiled with CFR 0.152.
 */
package stream;

import backtype.storm.Config;
import backtype.storm.StormSubmitter;
import backtype.storm.generated.StormTopology;
import backtype.storm.topology.TopologyBuilder;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import stream.StreamTopology;
import stream.io.SourceURL;
import stream.run;
import stream.util.XMLUtils;

public class Test {
    static Logger log = LoggerFactory.getLogger(Test.class);

    public static void main(String[] cliArgs) throws Exception {
        Document xml;
        log.info("Submitting streams container as storm topology...");
        TopologyBuilder builder = new TopologyBuilder();
        List params = run.handleArguments((String[])cliArgs);
        String[] args = params.toArray(new String[params.size()]);
        Properties p = new Properties();
        URL purl = Test.class.getResource("/test.properties");
        if (purl != null) {
            log.info("Loading properties from {}", (Object)purl);
            p.load(purl.openStream());
            System.getProperties().putAll((Map<?, ?>)p);
        }
        URL url = Test.class.getResource("/test.xml");
        if (System.getProperty("xml") != null) {
            log.info("Trying to use XML configuration from {}", (Object)System.getProperty("xml"));
            url = new URL(System.getProperty("xml"));
        }
        if (args.length > 0) {
            SourceURL src = new SourceURL(args[0]);
            log.info("Ttying to read configuration from {}", (Object)src);
            xml = XMLUtils.parseDocument((InputStream)src.openStream());
        } else {
            log.info("Reading XML configuration from {}", (Object)url);
            xml = XMLUtils.parseDocument((InputStream)url.openStream());
        }
        String id = xml.getDocumentElement().getAttribute("id");
        log.info("Container ID is '{}'", (Object)id);
        if (id == null || id.isEmpty()) {
            id = UUID.randomUUID().toString().toLowerCase();
        }
        if (System.getProperty("id") != null) {
            id = System.getProperty("id");
        }
        log.info("Using topology id '{}'", (Object)id);
        Config config = new Config();
        config.put((Object)Config.NIMBUS_HOST, (Object)System.getProperty("nimbus.host", "192.168.10.100"));
        config.put((Object)Config.NIMBUS_THRIFT_PORT, (Object)new Integer(System.getProperty("nimbus.port", "6627")));
        StreamTopology streamGraph = StreamTopology.build(xml, builder);
        StormTopology topology = streamGraph.createTopology();
        StormSubmitter.submitTopology((String)id, (Map)config, (StormTopology)topology);
    }
}

