/*
 * Decompiled with CFR 0.152.
 */
package stream.storm;

import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.tuple.Tuple;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.storm.AbstractBolt;

public class QueueBolt
extends AbstractBolt {
    private static final long serialVersionUID = -3206574886699994554L;
    static Logger log = LoggerFactory.getLogger(QueueBolt.class);
    OutputCollector output;

    public QueueBolt(String xmlConfig, String uuid) {
        super(xmlConfig, uuid);
    }

    public void prepare(Map stormConf, TopologyContext context, OutputCollector collector) {
        this.output = collector;
        log.info("  > Preparing queue '{}' with collector '{}'", (Object)this.uuid, (Object)collector);
    }

    public void execute(Tuple input) {
        log.debug("Executing for tuple {}", (Object)input);
        if (this.output != null) {
            log.debug("   emitting tuple...");
            this.output.emit(input.getValues());
        } else {
            log.debug("   no output defined, discarding tuple...");
        }
    }
}

