/*
 * Decompiled with CFR 0.152.
 */
package stream.storm;

import backtype.storm.task.OutputCollector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.io.Queue;
import stream.io.Sink;

public class QueueWrapper
implements Queue,
Sink,
Serializable {
    private static final long serialVersionUID = 5528349910849921579L;
    static Logger log = LoggerFactory.getLogger(QueueWrapper.class);
    final OutputCollector collector;
    final String name;

    public QueueWrapper(OutputCollector collector, String name) {
        this.collector = collector;
        this.name = name;
        log.debug("Creating QueueWrapper for queue '{}'", (Object)name);
    }

    public String getId() {
        return this.name;
    }

    public boolean write(Data item) throws Exception {
        log.debug("Writing to queue '{}'  (item is: {})", (Object)this.name, (Object)item);
        log.debug("   using collector {}", (Object)this.collector);
        ArrayList<Data> tuple = new ArrayList<Data>();
        tuple.add(item.createCopy());
        this.collector.emit(tuple);
        return true;
    }

    public void close() throws Exception {
    }

    public boolean write(Collection<Data> data) throws Exception {
        for (Data item : data) {
            ArrayList<Data> tuple = new ArrayList<Data>();
            tuple.add(item);
            this.collector.emit(tuple);
        }
        return true;
    }

    public void setId(String id) {
    }

    public void init() throws Exception {
    }

    public int clear() {
        return 0;
    }

    public Data read() throws Exception {
        return null;
    }

    public void setSize(Integer limit) {
    }

    public Integer getSize() {
        return Integer.MAX_VALUE;
    }
}

