/*
 * Decompiled with CFR 0.152.
 */
package stream.storm.config;

import backtype.storm.topology.IRichSpout;
import backtype.storm.topology.SpoutDeclarer;
import backtype.storm.topology.TopologyBuilder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import stream.StreamTopology;
import stream.runtime.setup.factory.ObjectFactory;
import stream.storm.StreamSpout;
import stream.storm.config.ATopologyElementHandler;
import stream.util.XMLElementMatch;

public class StreamHandler
extends ATopologyElementHandler {
    static Logger log = LoggerFactory.getLogger(StreamHandler.class);
    final String xml;

    public StreamHandler(ObjectFactory of, String xml) {
        super(of);
        this.xml = xml;
    }

    @Override
    public boolean handles(Element el) {
        String name = el.getNodeName();
        return name.equalsIgnoreCase("stream");
    }

    @Override
    public void handle(Element el, StreamTopology st, TopologyBuilder builder) throws Exception {
        if (!this.handles(el)) {
            return;
        }
        String id = el.getAttribute("id");
        if (id == null || id.trim().isEmpty()) {
            log.error("Missing attribute 'id' for element 'stream' with class '{}'!", (Object)el.getAttribute("class"));
            throw new Exception("Missing 'id' attribute for element 'stream'!");
        }
        log.info("  > Creating stream-spout with id '{}'", (Object)id);
        String className = el.getAttribute("class");
        log.info("  >   stream-class is: {}", (Object)className);
        Map params = ObjectFactory.newInstance().getAttributes((Node)el);
        log.info("  >   stream-parameters are: {}", (Object)params);
        params = st.getVariables().expandAll(params);
        log.info("  >   expanded stream-parameters are: {}", (Object)params);
        StreamSpout spout = new StreamSpout(this.xml, id, className, params);
        log.info("  >   stream-spout instance is: {}", (Object)spout);
        SpoutDeclarer spoutDeclarer = builder.setSpout(id, (IRichSpout)spout);
        log.info("  >   declared spout is: {}", (Object)spoutDeclarer);
        st.spouts.put(id, spoutDeclarer);
    }

    public static class StreamFinder
    implements XMLElementMatch {
        final String id;

        public StreamFinder(String id) {
            this.id = id;
        }

        public boolean matches(Element el) {
            return "stream".equalsIgnoreCase(el.getNodeName()) && this.id.equals(el.getAttribute("id"));
        }
    }
}

