/*
 * Decompiled with CFR 0.152.
 */
package storm;

import backtype.storm.Config;
import backtype.storm.StormSubmitter;
import backtype.storm.generated.StormTopology;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import stream.StreamTopology;
import stream.runtime.StreamRuntime;
import stream.util.XMLUtils;

public class deploy {
    static Logger log = LoggerFactory.getLogger(deploy.class);

    /*
     * WARNING - void declaration
     */
    public static List<String> handleArgs(String[] args) throws IOException {
        File userProps = new File(System.getProperty("user.home") + File.separator + ".streams.properties");
        if (userProps.canRead()) {
            System.out.println("Reading user-properties from " + userProps.getAbsolutePath() + ":");
            Properties p = new Properties();
            for (Object e : p.keySet()) {
                System.out.println("  " + e + " = " + p.getProperty(e.toString()));
            }
            p.load(new FileInputStream(userProps));
            System.getProperties().putAll((Map<?, ?>)p);
        }
        if (args.length != 1) {
            System.err.println("Expecting exactly a single XML configuration file.");
            System.exit(-1);
        }
        ArrayList<String> params = new ArrayList<String>();
        for (String arg : args) {
            params.add(arg);
        }
        Iterator it = params.iterator();
        while (it.hasNext()) {
            void var4_9;
            String string = (String)it.next();
            if (!string.startsWith("-")) continue;
            if (string.startsWith("--")) {
                String string2 = string.substring(2);
            } else {
                String string3 = string.substring(1);
            }
            if (var4_9.indexOf("=") > 0) {
                String[] kv = var4_9.split("=", 2);
                System.setProperty(kv[0], kv[1]);
            } else {
                System.setProperty((String)var4_9, "true");
            }
            it.remove();
        }
        return params;
    }

    public static void main(String[] args) {
        try {
            StreamRuntime.loadUserProperties();
            StreamRuntime.setupLogging();
            List<String> params = deploy.handleArgs(args);
            if (params.isEmpty()) {
                System.err.println("You need to specify an XML configuration!");
                System.exit(-1);
            }
            URL url = new File(params.get(0)).toURI().toURL();
            log.info("Creating topology with config from '{}'", (Object)url);
            Document doc = XMLUtils.parseDocument((InputStream)url.openStream());
            Element root = doc.getDocumentElement();
            String id = root.getAttribute("id");
            log.info("Container/topology ID is: '{}'", (Object)id);
            StreamTopology topology = StreamTopology.create(doc);
            Config config = new Config();
            log.info("Building sub-topology...");
            StormTopology stormTop = topology.createTopology();
            String name = id;
            if (id == null || id.trim().isEmpty()) {
                name = UUID.randomUUID().toString().toLowerCase();
            }
            log.info("Submitting topology '{}'", (Object)name);
            StormSubmitter.submitTopology((String)name, (Map)config, (StormTopology)stormTop);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

