/*
 * Decompiled with CFR 0.152.
 */
package storm;

import backtype.storm.Config;
import backtype.storm.StormSubmitter;
import backtype.storm.generated.StormTopology;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import stream.StreamTopology;
import stream.runtime.StreamRuntime;
import stream.util.XMLUtils;

public class deploy {
    static Logger log = LoggerFactory.getLogger(deploy.class);

    public static Set<String> getRequiredOptions() {
        LinkedHashSet<String> opts = new LinkedHashSet<String>();
        opts.add("nimbus.host");
        return Collections.unmodifiableSet(opts);
    }

    public static List<String> handleArgs(String[] args, Properties p) throws IOException {
        File userProps = new File(System.getProperty("user.home") + File.separator + ".streams.properties");
        if (userProps.canRead()) {
            System.out.println("Reading user-properties from " + userProps.getAbsolutePath() + ":");
            for (Object k : p.keySet()) {
                System.out.println("  " + k + " = " + p.getProperty(k.toString()));
            }
            p.load(new FileInputStream(userProps));
            System.getProperties().putAll((Map<?, ?>)p);
        }
        if (args.length != 1) {
            System.err.println("Expecting exactly a single XML configuration file.");
            System.exit(-1);
        }
        ArrayList<String> params = new ArrayList<String>();
        for (String arg : args) {
            params.add(arg);
        }
        Iterator it = params.iterator();
        while (it.hasNext()) {
            String param = (String)it.next();
            if (!param.startsWith("-")) continue;
            if ((param = param.startsWith("--") ? param.substring(2) : param.substring(1)).indexOf("=") > 0) {
                String[] kv = param.split("=", 2);
                System.setProperty(kv[0], kv[1]);
            } else {
                System.setProperty(param, "true");
            }
            it.remove();
        }
        return params;
    }

    public static void main(String[] args) {
        try {
            StreamRuntime.loadUserProperties();
            StreamRuntime.setupLogging();
            Properties p = new Properties();
            p.putAll((Map<?, ?>)System.getProperties());
            List<String> params = deploy.handleArgs(args, p);
            Config config = new Config();
            log.info("Building sub-topology...");
            for (Object object : p.keySet()) {
                log.info("Adding property   {} to storm config (value: '{}')", (Object)object.toString(), (Object)p.getProperty(object.toString()));
                config.put((Object)object.toString(), (Object)p.getProperty(object.toString()));
            }
            int err = 0;
            for (String opt : deploy.getRequiredOptions()) {
                if (config.containsKey((Object)opt)) continue;
                log.error("Required parameter '{}' not set!", (Object)opt);
                ++err;
            }
            if (err > 0) {
                log.error("{} required parameters missing.", (Object)err);
                System.exit(-1);
            }
            if (params.isEmpty()) {
                System.err.println("You need to specify an XML configuration!");
                System.exit(-1);
            }
            URL uRL = new File(params.get(0)).toURI().toURL();
            log.info("Creating topology with config from '{}'", (Object)uRL);
            Document doc = XMLUtils.parseDocument((InputStream)uRL.openStream());
            Element root = doc.getDocumentElement();
            String id = root.getAttribute("id");
            log.info("Container/topology ID is: '{}'", (Object)id);
            StreamTopology topology = StreamTopology.create(doc);
            StormTopology stormTop = topology.createTopology();
            String name = id;
            if (id == null || id.trim().isEmpty()) {
                name = UUID.randomUUID().toString().toLowerCase();
            }
            log.info("Submitting topology '{}'", (Object)name);
            StormSubmitter.submitTopology((String)name, (Map)config, (StormTopology)stormTop);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

