/*
 * Decompiled with CFR 0.152.
 */
package stream.storm.config;

import backtype.storm.topology.BoltDeclarer;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.TopologyBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import stream.StreamTopology;
import stream.runtime.setup.factory.ObjectFactory;
import stream.storm.QueueBolt;
import stream.storm.config.ATopologyElementHandler;

public class QueueHandler
extends ATopologyElementHandler {
    static Logger log = LoggerFactory.getLogger(QueueHandler.class);
    final String xml;

    public QueueHandler(ObjectFactory of, String xml) {
        super(of);
        this.xml = xml;
    }

    @Override
    public boolean handles(Element el) {
        return "queue".equalsIgnoreCase(el.getNodeName());
    }

    @Override
    public void handle(Element element, StreamTopology st, TopologyBuilder builder) throws Exception {
        BoltDeclarer boltDeclarer;
        String id = element.getAttribute("id");
        if (id == null || id.trim().isEmpty()) {
            throw new Exception("Queue element does not specify 'id' attribute!");
        }
        QueueBolt bolt = new QueueBolt(this.xml, id);
        log.info("  >   Registering bolt (queue) '{}' with instance {}", (Object)id, (Object)bolt);
        BoltDeclarer cur = boltDeclarer = builder.setBolt(id, (IRichBolt)bolt, (Number)1);
        log.debug("  >  Adding queue to stream-topology...");
        st.addBolt(id, cur);
    }
}

