/*
 * Decompiled with CFR 0.152.
 */
package stream;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.Processor;
import stream.annotations.Parameter;

public class MarkPeak2
implements Processor {
    static Logger log = LoggerFactory.getLogger(MarkPeak2.class);
    public static final int STATE_BELOW = -1;
    public static final int STATE_ABOVE = 1;
    protected String[] keys = null;
    protected int state = 1;
    protected Double threshold = 100.5;
    protected Double value = 255.0;

    public String[] getKeys() {
        return this.keys;
    }

    @Parameter(description="A list of attributes that need to exceed the threshold to make the data item a peak.")
    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    public Double getThreshold() {
        return this.threshold;
    }

    @Parameter(description="The threshold that needs to be traversed for a peak.")
    public void setThreshold(Double threshold) {
        this.threshold = threshold;
    }

    public Double getValue() {
        return this.value;
    }

    @Parameter(required=false, description="The value that is added to the data item to mark the peak, defaults to '1.0'")
    public void setValue(Double value) {
        this.value = value;
    }

    public Data process(Data input) {
        if (this.keys == null || this.keys.length == 0) {
            return input;
        }
        int below = 0;
        int above = 0;
        for (String key : this.keys) {
            Serializable val = (Serializable)input.get((Object)key);
            if (val == null) continue;
            Double value = Double.valueOf(val.toString());
            if (value > this.threshold) {
                ++above;
                continue;
            }
            ++below;
        }
        input.put((Object)"peak", (Object)0.0);
        if (above != this.keys.length && above != this.keys.length) {
            return input;
        }
        if (this.state == -1 && above == this.keys.length) {
            log.info("State was STATE_BELOW, but value fell below threshold, counting and switching state..");
            input.put((Object)"peak", (Object)0.0);
            this.state = -1;
            return input;
        }
        if (this.state == 1 && below == this.keys.length) {
            log.info("Switching state from STATE_ABOVE to STATE_BELOW");
            this.state = -1;
        }
        if (this.state == -1) {
            input.put((Object)"peak", (Object)this.value);
        } else {
            input.put((Object)"peak", (Object)0.0);
        }
        return input;
    }
}

