/*
 * Decompiled with CFR 0.152.
 */
package stream.coffee.eventdetection;

import stream.AbstractProcessor;
import stream.Data;
import stream.annotations.Parameter;

public class EventDetectionEvaluation
extends AbstractProcessor {
    Long lastrealevent = 0L;
    Long lastpredictedevent = 0L;
    Integer trueprediction = 0;
    Integer falseprediction = 0;
    Integer predictedEvents = 0;
    String label = "@label:event";
    String prediction = "@prediction:event";

    @Parameter(description="The key, under which the t label is stored.")
    public void setLabel(String label) {
        this.label = label;
    }

    @Parameter(description="The key, under which the predicted label is stored.")
    public void setPrediction(String prediction) {
        this.prediction = prediction;
    }

    public Data process(Data input) {
        String tlabel = (String)input.get((Object)this.label);
        String pprediction = (String)input.get((Object)this.prediction);
        Long frameid = (Long)input.get((Object)"frame:id");
        if (!tlabel.equalsIgnoreCase("no_event") && Math.abs(frameid - this.lastrealevent) > 6L) {
            this.lastrealevent = frameid;
        }
        if (pprediction.equalsIgnoreCase("event") && Math.abs(this.lastpredictedevent - frameid) > 6L) {
            this.lastpredictedevent = frameid;
            Integer n = this.predictedEvents;
            Integer n2 = this.predictedEvents = Integer.valueOf(this.predictedEvents + 1);
            if (Math.abs(this.lastrealevent - frameid) < 6L) {
                n = this.trueprediction;
                n2 = this.trueprediction = Integer.valueOf(this.trueprediction + 1);
                System.out.println("Real event on frames " + this.lastrealevent + " - " + (this.lastrealevent + 6L) + ". Predicted correctly on frame " + frameid);
            } else {
                n = this.falseprediction;
                n2 = this.falseprediction = Integer.valueOf(this.falseprediction + 1);
                System.out.println("Event predicted incorrectly on frame " + frameid);
            }
        }
        return input;
    }

    public void finish() throws Exception {
        System.out.println("Total amount of predicted events: " + this.predictedEvents);
        System.out.println("True Predictions: " + this.trueprediction + "; False Predictions: " + this.falseprediction);
        super.finish();
    }
}

