/*
 * Decompiled with CFR 0.152.
 */
package stream.coffee.eventdetection;

import stream.AbstractProcessor;
import stream.Data;
import stream.annotations.Parameter;

public class ThresholdEventDetection
extends AbstractProcessor {
    String attribute = "frame:red:average";
    Integer standardvalue = 120;
    Integer t = 50;
    String predictionkey = "@prediction:shotboundary";
    Long lastpredictedevent = 0L;

    @Parameter(description="Sets the threshold t to a new value.")
    public void setT(Integer t) {
        this.t = t;
    }

    public Integer getT() {
        return this.t;
    }

    @Parameter(description="Tells the processor, on which attribute to base the event detection on.")
    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getAttribute() {
        return this.attribute;
    }

    @Parameter(description="Sets the key under which the classifier stores the predicted label.")
    public void setPredictionkey(String predictionkey) {
        this.predictionkey = predictionkey;
    }

    public String getPredictionkey() {
        return this.predictionkey;
    }

    @Parameter(description="Sets the value the attribute has in random frames.")
    public void setStandardvalue(Integer standardvalue) {
        this.standardvalue = standardvalue;
    }

    public Integer getStandardvalue() {
        return this.standardvalue;
    }

    public Data process(Data input) {
        Double realvalue = (Double)input.get((Object)this.attribute);
        if (realvalue < (double)this.standardvalue.intValue() && Math.abs(realvalue - (double)this.standardvalue.intValue()) > (double)this.t.intValue()) {
            input.put((Object)this.predictionkey, (Object)"event");
        } else {
            input.put((Object)this.predictionkey, (Object)"no_event");
        }
        return input;
    }
}

