/*
 * Decompiled with CFR 0.152.
 */
package stream.coffee.helper;

import java.util.HashMap;
import java.util.Map;
import stream.AbstractProcessor;
import stream.Data;
import stream.ProcessContext;
import stream.annotations.Parameter;
import stream.io.CsvStream;
import stream.io.SourceURL;

public class AddCoffeeLabels
extends AbstractProcessor {
    String file = "file:///C:/Users/Matthias/Documents/SchulteSVN/Diplomarbeit/data/kapseln/kapseln.csv";
    private Map<Long, String> labels = new HashMap<Long, String>();

    @Parameter(description="Sets the file the labels are stored in.")
    public void setFile(String file) {
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    public void init(ProcessContext ctx) throws Exception {
        CsvStream stream = new CsvStream(new SourceURL(this.file));
        stream.init();
        Data item = stream.read();
        while (item != null) {
            String frame = (String)item.get((Object)"frame");
            String label = (String)item.get((Object)"label");
            for (int i = 0; i < 6; ++i) {
                this.labels.put(Long.parseLong(frame) + (long)i, label);
            }
            item = stream.read();
        }
        stream.close();
        super.init(ctx);
        System.out.println("Initalization of AddCoffeeLabels completed. " + this.labels.size() + " elements found.");
    }

    public Data process(Data input) {
        Long frame = (Long)input.get((Object)"frame:id");
        if (this.labels.containsKey(frame)) {
            input.put((Object)"@label:event", (Object)this.labels.get(frame));
        } else {
            input.put((Object)"@label:event", (Object)"no_event");
        }
        return input;
    }
}

