/*
 * Decompiled with CFR 0.152.
 */
package stream.image.features;

import stream.Data;
import stream.annotations.Parameter;
import stream.image.AbstractImageProcessor;
import stream.image.ImageRGB;

public class AverageRGB
extends AbstractImageProcessor {
    Boolean includeRatios = false;

    @Parameter(description="Sets, if the processor includes the ration between the color channels, or just the average RGB color values. Ratios are (red/blue), (red/green), (green/blue).", defaultValue="false")
    public void setIncludeRatios(boolean includeRatios) {
        this.includeRatios = includeRatios;
    }

    public Boolean getIncludeRatios() {
        return this.includeRatios;
    }

    @Override
    public Data process(Data item, ImageRGB img) {
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        double px = img.pixels.length;
        for (int i = 0; i < img.pixels.length; ++i) {
            int argb = img.pixels[i];
            int red = argb >> 16 & 0xFF;
            int green = argb >> 8 & 0xFF;
            int blue = argb & 0xFF;
            r += (double)red;
            g += (double)green;
            b += (double)blue;
        }
        item.put((Object)"frame:red:average", (Object)(r /= px));
        item.put((Object)"frame:blue:average", (Object)(b /= px));
        item.put((Object)"frame:green:average", (Object)(g /= px));
        if (this.includeRatios.booleanValue()) {
            item.put((Object)"frame:ratio:red_blue", (Object)(r / b));
            item.put((Object)"frame:ratio:red_green", (Object)(r / g));
            item.put((Object)"frame:ratio:green_blue", (Object)(g / b));
        }
        return item;
    }
}

