/*
 * Decompiled with CFR 0.152.
 */
package stream.image.features;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.image.AbstractImageProcessor;
import stream.image.ImageRGB;

public class MnistFeatures
extends AbstractImageProcessor {
    static Logger log = LoggerFactory.getLogger(MnistFeatures.class);
    int limit = 625;

    @Override
    public Data process(Data item, ImageRGB img) {
        int idx;
        int x;
        int y;
        int dim = img.getWidth() * img.getHeight();
        log.info("Creating {} features", (Object)dim);
        if (dim > this.limit) {
            // empty if block
        }
        int[] rgb = img.getPixels();
        double[] features = new double[dim];
        double cx = 0.0;
        double cy = 0.0;
        double cnt = 0.0;
        for (y = 0; y < img.getHeight(); ++y) {
            for (x = 0; x < img.getWidth(); ++x) {
                idx = y * img.getWidth() + x;
                if (rgb[idx] <= 0) continue;
                cy += (double)y;
                cx += (double)x;
                cnt += 1.0;
            }
        }
        cx /= cnt;
        cy /= cnt;
        for (y = 0; y < img.getHeight(); ++y) {
            for (x = 0; x < img.getWidth(); ++x) {
                idx = y * img.getWidth() + x;
                if (rgb[idx] <= 0) continue;
                cy += (double)y;
                cx += (double)x;
                cnt += 1.0;
            }
        }
        for (int i = 0; i < features.length; ++i) {
            if (!(features[i] > 0.0)) continue;
            item.put((Object)String.format("mnist:%d", i), (Object)new Double(features[i]));
        }
        return item;
    }
}

