/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class Copy {
    public static final byte[] JPEG_SOI = new byte[]{-1, -40};
    public static final byte[] JPEG_EOI = new byte[]{-1, -39};
    static final ArrayList<byte[]> chunks = new ArrayList();

    public static void main(String[] args) throws IOException {
        FileOutputStream out = null;
        InputStream in = "-".equals(args[0]) ? System.in : new FileInputStream(new File(args[0]));
        if (args.length > 1) {
            File file = new File(args[1]);
            System.err.println("Copying standard output to " + file);
            out = new FileOutputStream(file);
        }
        boolean verbose = System.getProperty("verbose") != null;
        byte[] buf = new byte[0x1000000];
        int total = 0;
        int read = 0;
        int count = 0;
        Long frames = 0L;
        long begin = System.currentTimeMillis();
        ByteBuffer current = ByteBuffer.allocateDirect(buf.length * 4);
        while (true) {
            if (in.available() == 0) {
                try {
                    Thread.sleep(5L);
                }
                catch (Exception e) {}
                continue;
            }
            read = in.read(buf);
            if (verbose) {
                System.out.println(read + " bytes read.");
            }
            int idx = Copy.indexOf(buf, JPEG_SOI, 0);
            int offset = 0;
            if (idx >= 0) {
                System.err.println("Found JPG SOI at " + idx);
                offset = idx;
                byte[] img = new byte[current.position() + idx];
                current.flip();
                current.get(img);
                Long l = frames;
                Long l2 = frames = Long.valueOf(frames + 1L);
                chunks.add(img);
                if (chunks.size() > 10) {
                    System.err.println("Dropping frame...");
                    chunks.remove(0);
                }
                current.clear();
            } else if (current.remaining() < buf.length) {
                System.err.println("No start found, buffer full, clearing buffer and starting anew");
                current.clear();
            }
            current.put(buf, offset, read - offset);
            if (read > 0) {
                if (out != null) {
                    ((OutputStream)out).write(buf, 0, read);
                }
                total += read;
                ++count;
                if (verbose || frames % 10L == 0L) {
                    Long time = System.currentTimeMillis() - begin;
                    Double seconds = time.doubleValue() / 1000.0;
                    System.err.println(count + " reads, " + total + " bytes read so far (" + (double)total / seconds + " bytes/second)");
                    System.err.println(frames + " frames read (" + frames.doubleValue() / seconds + " fps)");
                }
            }
            if (read < 0) break;
        }
        System.err.println(total + " bytes written, last read was: " + read);
    }

    protected static boolean isSignatureAt(byte[] buffer, int pos, byte[] sig) {
        for (int i = 0; i < sig.length; ++i) {
            byte b = buffer[pos + i];
            if (b == sig[i]) continue;
            return false;
        }
        return true;
    }

    protected static int indexOf(byte[] buffer, byte[] sig, int from) {
        int pos = from;
        while (pos + sig.length < buffer.length && !Copy.isSignatureAt(buffer, pos, sig)) {
            ++pos;
        }
        if (pos + sig.length >= buffer.length) {
            return -1;
        }
        return pos;
    }
}

