/*
 * Decompiled with CFR 0.152.
 */
package stream.laser;

import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealMatrixImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.laser.Marker;
import stream.laser.SteelPanel;
import stream.laser.Trapez;
import stream.laser.TrapezCorrection;
import stream.laser.game.PointT;
import stream.net.PointerListener;
import stream.video.TrapezoidCorrection;

public class Calibration
implements PointerListener {
    static Logger log = LoggerFactory.getLogger(Calibration.class);
    final SteelPanel panel;
    Marker mark;
    boolean running = false;
    public static final RealMatrix IDENTITY = new RealMatrixImpl((double[][])new double[][]{{1.0, 0.0}, {0.0, 1.0}});
    Long last = 0L;
    PointT lastPoint = null;
    double offX = 0.0;
    double offY = 0.0;
    double scaleX = 1.0;
    double scaleY = 1.0;
    int lastMark = -1;
    List<Marker> calibrationMarks = new ArrayList<Marker>();
    Map<Marker, PointT> calibrationPoints = new LinkedHashMap<Marker, PointT>();
    Trapez trapez;
    TrapezCorrection mapping;

    public Calibration(SteelPanel panel) {
        this.panel = panel;
        int border = 8;
        int w = panel.getWidth();
        int h = panel.getHeight();
        log.info("Panel size is: {} x {}", (Object)panel.getWidth(), (Object)panel.getHeight());
        this.calibrationMarks.add(new Marker(border, border, Color.white));
        this.calibrationMarks.add(new Marker(border, h - border, Color.WHITE));
        this.calibrationMarks.add(new Marker(w - border, border, Color.WHITE));
        this.calibrationMarks.add(new Marker(w - border, h - border, Color.WHITE));
        this.calibrationMarks.add(new Marker(-1, -1, Color.white));
    }

    public void nextMark() {
        ++this.lastMark;
        if (this.mark != null) {
            this.panel.remove(this.mark);
        }
        this.mark = this.calibrationMarks.get(this.lastMark % this.calibrationMarks.size());
        if (this.mark.x.floatValue() < 0.0f && this.mark.y.floatValue() < 0.0f) {
            log.info("Skipping empty calibration mark...");
            log.info("Calibration marks are finished, current setup is:");
            for (Marker mark : this.calibrationPoints.keySet()) {
                log.info("   Marker: {}", (Object)mark);
                log.info("   PointT: {}", (Object)this.calibrationPoints.get(mark));
            }
            Marker tlm = this.calibrationMarks.get(0);
            Marker blm = this.calibrationMarks.get(1);
            Marker trm = this.calibrationMarks.get(2);
            Marker brm = this.calibrationMarks.get(3);
            PointT tl = this.calibrationPoints.get(tlm);
            PointT bl = this.calibrationPoints.get(blm);
            PointT tr = this.calibrationPoints.get(trm);
            PointT br = this.calibrationPoints.get(brm);
            Trapez x = this.trapez = new Trapez(tl, bl, tr, br);
            this.panel.setTrapez(this.trapez);
            try {
                Trapez g = new Trapez(tlm.getPoint(), blm.getPoint(), trm.getPoint(), brm.getPoint());
                RealMatrix At = TrapezoidCorrection.compute(x, g);
                log.info("Correction:\n{}", (Object)At);
                this.mapping = new TrapezoidCorrection(At);
                log.info("tl {} mapped to {}", (Object)tlm.getPoint(), (Object)this.mapping.map(tlm.getPoint()));
                log.info("bl {} mapped to {}", (Object)blm.getPoint(), (Object)this.mapping.map(blm.getPoint()));
                log.info("tr {} mapped to {}", (Object)trm.getPoint(), (Object)this.mapping.map(trm.getPoint()));
                log.info("br {} mapped to {}", (Object)brm.getPoint(), (Object)this.mapping.map(brm.getPoint()));
            }
            catch (Exception e) {
                this.mapping = null;
            }
            this.offX = tl.x;
            this.offY = tl.y;
            this.scaleX = 1.0 / (double)((float)(tr.x - tl.x) / (trm.x.floatValue() - tlm.x.floatValue()));
            this.scaleY = 1.0 / (double)((float)(bl.y - tl.y) / (blm.y.floatValue() - tlm.y.floatValue()));
            log.info("off-x: {}, off-y: {}", (Object)this.offX, (Object)this.offY);
            log.info("scale-x: {}, scale-y: {}", (Object)this.scaleX, (Object)this.scaleY);
        } else {
            log.info("Current mark is at: {},{}", (Object)this.mark.x, (Object)this.mark.y);
            this.panel.add(this.mark);
        }
        this.panel.drawableChanged();
    }

    @Override
    public void pointingAt(int x, int y) {
        if (this.mark != null && this.mark.x.floatValue() >= 0.0f && this.mark.y.floatValue() >= 0.0f) {
            log.info("Associating mark {} with {}", (Object)this.mark, (Object)this.lastPoint);
            this.calibrationPoints.put(this.mark, this.lastPoint);
        }
        this.lastPoint = new PointT(x, y);
        this.panel.drawableChanged();
        if (this.mapping != null && "true".equals(System.getProperty("trapezKorrektur"))) {
            log.info("Using Trapez-Korrektur");
            Point mapped = this.mapping.map(new Point(x, y));
            log.info("Point is: {},{}", (Object)x, (Object)y);
            log.info("Mapped point is: {},{}", (Object)mapped.x, (Object)mapped.y);
            this.panel.pointingAt(mapped.x, mapped.y);
            this.last = System.currentTimeMillis();
            return;
        }
        PointT point = new PointT(((double)x - this.offX) * this.scaleX, ((double)y - this.offY) * this.scaleY);
        this.panel.pointingAt(point.x, point.y);
        this.last = System.currentTimeMillis();
    }

    protected void sleep(int s) {
        try {
            Thread.sleep(s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        this.running = false;
    }
}

