/*
 * Decompiled with CFR 0.152.
 */
package stream.laser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.net.PointerListener;

public class FakePointer
extends JFrame
implements PointerListener {
    private static final long serialVersionUID = 2382902890546415714L;
    static Logger log = LoggerFactory.getLogger(FakePointer.class);
    PointerListener plistener;

    public FakePointer(PointerListener pl) {
        this.plistener = pl;
        TouchPanel tp = new TouchPanel(this.plistener);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)tp, "Center");
    }

    @Override
    public void pointingAt(int x, int y) {
        log.info("Pointing to {},{}", (Object)x, (Object)y);
    }

    public static void main(String[] args) {
        FakePointer fp = new FakePointer(new PointerListener(){

            @Override
            public void pointingAt(int x, int y) {
                log.info("TouchPanel pointing at {},{}", (Object)x, (Object)y);
            }
        });
        fp.setSize(300, 125);
        fp.setVisible(true);
    }

    public class TouchPanel
    extends JPanel {
        private static final long serialVersionUID = -7190383631437977979L;
        final PointerListener listener;
        Point pointer;

        public TouchPanel(PointerListener l) {
            this.listener = l;
            MouseAdapter ml = new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    TouchPanel.this.listener.pointingAt(e.getX(), e.getY());
                    TouchPanel.this.pointer = e.getPoint();
                    TouchPanel.this.repaint();
                    TouchPanel.this.validate();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    TouchPanel.this.pointer = null;
                    TouchPanel.this.repaint();
                    TouchPanel.this.validate();
                }
            };
            this.addMouseMotionListener(ml);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.pointer != null) {
                g.fillOval(this.pointer.x - 1, this.pointer.y - 1, 3, 3);
            }
        }
    }
}

