/*
 * Decompiled with CFR 0.152.
 */
package stream.laser;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.io.SourceURL;
import stream.io.WavStream;

public class LaserSound {
    static Logger log = LoggerFactory.getLogger(LaserSound.class);
    final String[] names = new String[]{"on0", "off0", "swing7"};
    final Map<String, Data> sounds = new HashMap<String, Data>();
    AudioFormat header;
    SourceDataLine audio;

    public LaserSound() {
        for (String name : this.names) {
            Data sound;
            URL url = LaserSound.class.getResource("/laser/game/sounds/new-" + name + ".wav");
            if (url == null || (sound = LaserSound.readSound(url)) == null) continue;
            this.sounds.put(name, sound);
        }
    }

    public void init() {
        try {
            Long sampleRate = 48000L;
            Integer channels = 1;
            Integer bytesPerSample = 1;
            this.header = new AudioFormat(sampleRate.floatValue(), 8 * bytesPerSample, channels, true, false);
            log.info("Initializing audio output...");
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.header);
            try {
                log.info("Acquiring audio-line from AudioSystem...");
                this.audio = (SourceDataLine)AudioSystem.getLine(info);
                log.info("Opening audio-line...");
                this.audio.open(this.header, 262144);
            }
            catch (LineUnavailableException e) {
                log.error("Unable to acquire audio-line: {}", (Object)e.getMessage());
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void play(String key) {
        Data item = this.sounds.get(key);
        if (item != null) {
            if (!this.audio.isRunning()) {
                log.debug("Starting audio-device...");
                this.audio.start();
            }
            double[] samples = (double[])item.get((Object)"wav:samples");
            byte[] bytes = new byte[samples.length];
            for (int i = 0; i < samples.length; ++i) {
                bytes[i] = (byte)(0.5 * samples[i]);
            }
            log.debug("Writing {} bytes to audio-line...", (Object)bytes.length);
            this.audio.write(bytes, 0, bytes.length);
        } else {
            log.debug("Sound '{}' not loaded!");
        }
    }

    public Set<String> getSoundNames() {
        return this.sounds.keySet();
    }

    public static Data readSound(URL url) {
        try {
            SourceURL source = new SourceURL(url);
            WavStream stream = new WavStream(source);
            stream.setBlockSize(480000);
            stream.init();
            Data sound = stream.read();
            double[] samples = (double[])sound.get((Object)"wav:samples");
            stream.close();
            return sound;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        try {
            LaserSound sounds = new LaserSound();
            sounds.init();
            sounds.play("off0");
            sounds.play("on0");
            Thread.sleep(5000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

