/*
 * Decompiled with CFR 0.152.
 */
package stream.laser;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ImageIcon;
import stream.laser.game.PointT;

public class LaserSword
extends MouseAdapter {
    final ArrayList<PointT> trace = new ArrayList();
    ImageIcon icon;
    boolean active = false;

    public LaserSword() {
        try {
            this.icon = new ImageIcon(LaserSword.class.getResource("/animated-flame.gif"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        this.active = true;
        e.getComponent().repaint();
        e.getComponent().validate();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        this.active = false;
        e.getComponent().repaint();
        e.getComponent().validate();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        this.trace.add(new PointT(e.getPoint()));
        Iterator<PointT> it = this.trace.iterator();
        while (it.hasNext()) {
            PointT p = it.next();
            if (p.age() <= 5000L) continue;
            System.out.println("Removing point with age=" + p.age());
            it.remove();
        }
        e.getComponent().repaint();
        e.getComponent().validate();
    }

    public boolean active() {
        return this.active;
    }

    public ImageIcon getFlame() {
        return this.icon;
    }

    public ArrayList<PointT> getTrace() {
        return this.trace;
    }
}

