/*
 * Decompiled with CFR 0.152.
 */
package stream.laser;

import java.awt.Point;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.ProcessContext;
import stream.image.AbstractImageProcessor;
import stream.image.ImageRGB;

public class LaserTrackerGreen
extends AbstractImageProcessor {
    static Logger log = LoggerFactory.getLogger(LaserTrackerGreen.class);
    protected String laserImage = null;
    protected ImageRGB lastImage = null;
    protected Point initialPoint = null;
    protected int initialRGB;
    protected int searchSize = 20;
    protected int threshold = 20;
    protected int frame = 0;
    protected String output = this.imageKey;
    protected boolean skipWithoutPoint = false;
    protected DatagramSocket socket;
    protected String address;
    protected int port = 9105;
    protected InetAddress addr;
    protected DatagramPacket packet;
    protected int evalMagic = 0;
    protected int initialMagic = 0;
    protected Point[] fPoints = new Point[this.fSize];
    private int c = 0;
    private int fSize = 1;

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public int getSearchSize() {
        return this.searchSize;
    }

    public void setSearchSize(int searchSize) {
        this.searchSize = searchSize;
    }

    public String getLaserImage() {
        return this.laserImage;
    }

    public void setLaserImage(String laserImage) {
        this.laserImage = laserImage;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public boolean isSkipWithoutPoint() {
        return this.skipWithoutPoint;
    }

    public void setSkipWithoutPoint(boolean skipWithoutPoint) {
        this.skipWithoutPoint = skipWithoutPoint;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        if (this.address != null) {
            this.socket = new DatagramSocket();
            this.addr = InetAddress.getByName(this.address);
            this.packet = new DatagramPacket(new byte[0], 0, this.addr, this.port);
        }
    }

    @Override
    public Data process(Data item, ImageRGB img) {
        if (this.frame > 0 && this.frame % 2 == 0) {
            return item;
        }
        if (this.initialPoint == null) {
            this.initialPoint = this.getInitialPoint(img);
            if (this.initialPoint != null) {
                this.initialRGB = img.getRGB(this.initialPoint.x, this.initialPoint.y);
                log.info("********************* found initial point {} ***************************", (Object)this.initialPoint);
                if (this.c < this.fPoints.length) {
                    this.fPoints[this.c++] = this.initialPoint;
                    for (Point fp : this.fPoints) {
                        if (fp == null) break;
                        this.markLaserPointer2(fp, img, 0, 255, 0);
                    }
                } else {
                    this.fPoints = new Point[this.fSize];
                    this.c = 0;
                }
                this.sendUDP();
            }
            item.put((Object)this.output, (Object)img);
            return item;
        }
        if (this.initialMagic < 1) {
            Point cp = this.getInitialPoint(img);
            if (cp != null) {
                double magicDist = this.dist(this.initialPoint, cp);
                if (magicDist < 100.0) {
                    ++this.initialMagic;
                } else {
                    this.initialMagic = 0;
                    this.initialPoint = null;
                }
            }
            item.put((Object)this.output, (Object)img);
            return item;
        }
        Point evalPoint = this.evaluateLaserPointer(this.initialPoint, this.initialRGB, img);
        if (evalPoint != null) {
            this.initialPoint = evalPoint;
            if (this.initialPoint.x < 0 || this.initialPoint.y < 0) {
                log.info("Weird initial point: {}", (Object)this.initialPoint);
                this.initialPoint = null;
                this.initialMagic = 0;
                return item;
            }
            this.initialRGB = img.getRGB(this.initialPoint.x, this.initialPoint.y);
            this.markLaserPointer(this.initialPoint, img, 255, 0, 0);
            if (this.c < this.fPoints.length) {
                this.fPoints[this.c++] = this.initialPoint;
                for (Point fp : this.fPoints) {
                    if (fp == null) break;
                    this.markLaserPointer2(fp, img, 0, 255, 0);
                }
            } else {
                this.fPoints = new Point[this.fSize];
                this.c = 0;
            }
            item.put((Object)this.output, (Object)img);
            item.put((Object)"laser:x", (Object)this.initialPoint.x);
            item.put((Object)"laser:y", (Object)this.initialPoint.y);
            this.sendUDP();
            return item;
        }
        this.initialPoint = null;
        this.initialRGB = -1;
        this.initialMagic = 0;
        return item;
    }

    private void sendUDP() {
        block4: {
            if (this.socket != null && this.packet != null && this.initialPoint != null) {
                try {
                    byte[] buf = ("(" + this.initialPoint.x + "," + this.initialPoint.y + ")").getBytes();
                    if (this.socket != null) {
                        this.packet.setData(buf);
                        this.socket.send(this.packet);
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block4;
                    e.printStackTrace();
                }
            }
        }
    }

    private Point evaluateLaserPointer(Point ep, int oldRGB, ImageRGB img) {
        int size = this.searchSize;
        int count = 10;
        Point[] points = new Point[count];
        int minThreshold = this.threshold;
        int minx = ep.x - size > 0 ? ep.x - size : 0;
        int maxx = ep.x + size > img.width - 1 ? img.width - 1 : ep.x + size;
        int miny = ep.y - size > 0 ? ep.y - size : 0;
        int maxy = ep.y + size > img.height - 1 ? img.height - 1 : ep.y + size;
        int[] pixels = img.pixels;
        for (int x = minx; x < maxx; ++x) {
            for (int y = miny; y < maxy; ++y) {
                int gold;
                int rdiff;
                int idx = y * img.width + x;
                int rgbnew = pixels[idx];
                int gnew = rgbnew >> 8 & 0xFF;
                if (gnew <= 20 || (rdiff = Math.abs((gold = oldRGB >> 8 & 0xFF) - gnew)) >= minThreshold) continue;
                for (int i = count - 1; i > 0; --i) {
                    points[i] = points[i - 1];
                }
                minThreshold = rdiff;
                points[0] = new Point(x, y);
            }
        }
        Point p = this.weightedAverage(ep, points);
        if (p == null && this.evalMagic < 1) {
            ++this.evalMagic;
            return ep;
        }
        this.evalMagic = 0;
        return p;
    }

    private Point getInitialPoint(ImageRGB img) {
        int px = -1;
        int py = -1;
        int maxR = 50;
        int[] pixels = img.getPixels();
        for (int x = 0; x < img.width; ++x) {
            for (int y = 0; y < img.height; ++y) {
                int idx = y * img.getWidth() + x;
                int rgb = pixels[idx];
                int r = rgb >> 8 & 0xFF;
                if (r < maxR) continue;
                px = x;
                py = y;
            }
        }
        if (px >= 0 && py >= 0) {
            return new Point(px, py);
        }
        return null;
    }

    private void markLaserPointer(Point p, ImageRGB img, int r, int g, int b) {
        int x = p.x;
        int y = p.y;
        int color = r;
        color = (color << 8) + g;
        color = (color << 8) + b;
        int idx = (y - 5) * img.width + x - 5;
        if (idx < img.pixels.length && idx >= 0) {
            img.pixels[idx] = color;
        }
        if ((idx = (y + 5) * img.width + x - 5) < img.pixels.length && idx >= 0) {
            img.pixels[idx] = color;
        }
        if ((idx = (y - 5) * img.width + x + 5) < img.pixels.length && idx >= 0) {
            img.pixels[idx] = color;
        }
        if ((idx = (y + 5) * img.width + x + 5) < img.pixels.length && idx >= 0) {
            img.pixels[idx] = color;
        }
    }

    private void markLaserPointer2(Point p, ImageRGB img, int r, int g, int b) {
        int x = p.x;
        int y = p.y;
        int color = r;
        color = (color << 8) + g;
        color = (color << 8) + b;
        int idx = (y - 1) * img.width + x - 1;
        if (idx < img.pixels.length && idx >= 0) {
            img.pixels[idx] = color;
        }
        if ((idx = (y + 1) * img.width + x - 1) < img.pixels.length && idx >= 0) {
            img.pixels[idx] = color;
        }
        if ((idx = (y - 1) * img.width + x + 1) < img.pixels.length && idx >= 0) {
            img.pixels[idx] = color;
        }
        if ((idx = (y + 1) * img.width + x + 1) < img.pixels.length && idx >= 0) {
            img.pixels[idx] = color;
        }
    }

    public double dist(Point p, Point q) {
        return p.distance(q.getX(), q.getY());
    }

    private Point findMinDist(Point p, Point[] points) {
        int minp = points.length;
        double dist = 0.0;
        double minDist = Double.MAX_VALUE;
        for (int i = 0; i < points.length; ++i) {
            Point ep = points[i];
            if (ep == null || !((dist = this.dist(p, ep)) < minDist)) continue;
            minp = i;
            minDist = dist;
        }
        return minp == points.length ? null : points[minp];
    }

    private Point average(Point ep, Point[] points) {
        int x = 0;
        int y = 0;
        int count = 0;
        for (Point p : points) {
            if (p != null) {
                x += p.x;
                y += p.y;
                continue;
            }
            ++count;
        }
        if (count == points.length) {
            return null;
        }
        Point r = new Point(x /= points.length, y /= points.length);
        log.info("found point {}", (Object)r);
        return r;
    }

    private Point weightedAverage(Point ep, Point[] points) {
        int x = 0;
        int y = 0;
        int count = 0;
        double dist = 0.0;
        for (Point p : points) {
            if (p != null) {
                double d = this.dist(ep, p);
                dist += (double)this.searchSize - d;
                x = (int)((double)x + (double)p.x * ((double)this.searchSize - d));
                y = (int)((double)y + (double)p.y * ((double)this.searchSize - d));
                continue;
            }
            ++count;
        }
        if (count == points.length) {
            return null;
        }
        x = (int)((double)x / dist);
        y = (int)((double)y / dist);
        Point r = new Point(x, y);
        log.info("found point {}", (Object)r);
        return r;
    }
}

