/*
 * Decompiled with CFR 0.152.
 */
package stream.laser;

import java.awt.Point;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.ProcessContext;
import stream.image.AbstractImageProcessor;
import stream.image.ImageRGB;
import stream.laser.LaserTrackerGreen;

public class LaserTrackerGreenNew
extends AbstractImageProcessor {
    static Logger log = LoggerFactory.getLogger(LaserTrackerGreen.class);
    protected String laserImage = null;
    protected ImageRGB lastImage = null;
    protected Point initialPoint = null;
    protected int initialRGB;
    protected int searchSize = 20;
    protected int threshold = 20;
    protected int frame = 0;
    protected String output = this.imageKey;
    protected boolean skipWithoutPoint = false;
    protected DatagramSocket socket;
    protected String address;
    protected int port = 9105;
    protected InetAddress addr;
    protected DatagramPacket packet;
    private int c = 0;

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public int getSearchSize() {
        return this.searchSize;
    }

    public void setSearchSize(int searchSize) {
        this.searchSize = searchSize;
    }

    public String getLaserImage() {
        return this.laserImage;
    }

    public void setLaserImage(String laserImage) {
        this.laserImage = laserImage;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public boolean isSkipWithoutPoint() {
        return this.skipWithoutPoint;
    }

    public void setSkipWithoutPoint(boolean skipWithoutPoint) {
        this.skipWithoutPoint = skipWithoutPoint;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        if (this.address != null) {
            this.socket = new DatagramSocket();
            this.addr = InetAddress.getByName(this.address);
            this.packet = new DatagramPacket(new byte[0], 0, this.addr, this.port);
        }
    }

    @Override
    public Data process(Data item, ImageRGB img) {
        if (this.initialPoint == null) {
            this.initialPoint = this.getInitialPoint(img);
            if (this.initialPoint != null) {
                this.initialRGB = img.getRGB(this.initialPoint.x, this.initialPoint.y);
                log.info("********************* found initial point {} ***************************", (Object)this.initialPoint);
                this.markLaserPointer2(this.initialPoint, img, 255, 0, 0);
            }
            item.put((Object)this.output, (Object)img);
            return item;
        }
        Point evalPoint = this.evaluateLaserPointer(this.initialPoint, this.initialRGB, img);
        if (evalPoint != null) {
            log.info("Found laserPointer");
            this.initialPoint = evalPoint;
            if (this.initialPoint.x < 0 || this.initialPoint.y < 0) {
                log.info("Weird initial point: {}", (Object)this.initialPoint);
                this.initialPoint = null;
                return item;
            }
            this.initialRGB = img.getRGB(this.initialPoint.x, this.initialPoint.y);
            this.markLaserPointer(this.initialPoint, img, 255, 0, 0);
            log.info("********************* found eval point {} ***************************", (Object)this.initialPoint);
            item.put((Object)this.output, (Object)img);
            item.put((Object)"laser:x", (Object)this.initialPoint.x);
            item.put((Object)"laser:y", (Object)this.initialPoint.y);
            this.sendUDP();
            return item;
        }
        log.info("Cant eval laserPointer");
        if (this.c > 4) {
            this.initialPoint = null;
            this.initialRGB = -1;
            this.c = 0;
        } else {
            ++this.c;
        }
        return item;
    }

    private void sendUDP() {
        block4: {
            if (this.socket != null && this.packet != null && this.initialPoint != null) {
                try {
                    byte[] buf = ("(" + this.initialPoint.x + "," + this.initialPoint.y + ")").getBytes();
                    if (this.socket != null) {
                        this.packet.setData(buf);
                        this.socket.send(this.packet);
                        log.info("send" + new String(buf));
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block4;
                    e.printStackTrace();
                }
            }
        }
    }

    private Point evaluateLaserPointer(Point ep, int oldRGB, ImageRGB img) {
        int size = this.searchSize;
        int count = 100;
        Point[] points = new Point[count];
        int minThreshold = this.threshold;
        int minx = ep.x - size > 0 ? ep.x - size : 0;
        int maxx = ep.x + size > img.width - 1 ? img.width - 1 : ep.x + size;
        int miny = ep.y - size > 0 ? ep.y - size : 0;
        int maxy = ep.y + size > img.height - 1 ? img.height - 1 : ep.y + size;
        int[] pixels = img.pixels;
        int i = 0;
        block0: for (int x = minx; x < maxx; ++x) {
            for (int y = miny; y < maxy; ++y) {
                int idx = y * img.width + x;
                int rgbnew = pixels[idx];
                int gnew = rgbnew >> 8 & 0xFF;
                if (gnew <= this.threshold) continue;
                points[i] = new Point(x, y);
                if (++i == points.length) break block0;
            }
        }
        Point p = this.weightedAverage(ep, points);
        return p;
    }

    private Point getInitialPoint(ImageRGB img) {
        int px = -1;
        int py = -1;
        int maxR = 50;
        int[] pixels = img.getPixels();
        for (int x = 0; x < img.width; ++x) {
            for (int y = 0; y < img.height; ++y) {
                int idx = y * img.getWidth() + x;
                int rgb = pixels[idx];
                int r = rgb >> 8 & 0xFF;
                if (r < maxR) continue;
                px = x;
                py = y;
            }
        }
        if (px >= 0 && py >= 0) {
            return new Point(px, py);
        }
        return null;
    }

    private void markLaserPointer(Point p, ImageRGB img, int r, int g, int b) {
        int x = p.x;
        int y = p.y;
        int color = r;
        color = (color << 8) + g;
        color = (color << 8) + b;
        int idx = (y - 5) * img.width + x - 5;
        if (idx < img.pixels.length && idx >= 0) {
            img.pixels[idx] = color;
        }
        if ((idx = (y + 5) * img.width + x - 5) < img.pixels.length && idx >= 0) {
            img.pixels[idx] = color;
        }
        if ((idx = (y - 5) * img.width + x + 5) < img.pixels.length && idx >= 0) {
            img.pixels[idx] = color;
        }
        if ((idx = (y + 5) * img.width + x + 5) < img.pixels.length && idx >= 0) {
            img.pixels[idx] = color;
        }
    }

    private void markLaserPointer2(Point p, ImageRGB img, int r, int g, int b) {
        int x = p.x;
        int y = p.y;
        int color = r;
        color = (color << 8) + g;
        color = (color << 8) + b;
        int idx = (y - 1) * img.width + x - 1;
        if (idx < img.pixels.length && idx >= 0) {
            img.pixels[idx] = color;
        }
        if ((idx = (y + 1) * img.width + x - 1) < img.pixels.length && idx >= 0) {
            img.pixels[idx] = color;
        }
        if ((idx = (y - 1) * img.width + x + 1) < img.pixels.length && idx >= 0) {
            img.pixels[idx] = color;
        }
        if ((idx = (y + 1) * img.width + x + 1) < img.pixels.length && idx >= 0) {
            img.pixels[idx] = color;
        }
    }

    public double dist(Point p, Point q) {
        return p.distance(q.getX(), q.getY());
    }

    private Point findMinDist(Point p, Point[] points) {
        int minp = points.length;
        double dist = 0.0;
        double minDist = Double.MAX_VALUE;
        for (int i = 0; i < points.length; ++i) {
            Point ep = points[i];
            if (ep == null || !((dist = this.dist(p, ep)) < minDist)) continue;
            minp = i;
            minDist = dist;
        }
        return minp == points.length ? null : points[minp];
    }

    private Point average(Point ep, Point[] points) {
        int x = 0;
        int y = 0;
        int count = 0;
        for (Point p : points) {
            if (p != null) {
                x += p.x;
                y += p.y;
                continue;
            }
            ++count;
        }
        if (count == points.length) {
            return null;
        }
        Point r = new Point(x /= points.length, y /= points.length);
        log.info("found point {}", (Object)r);
        return r;
    }

    private Point weightedAverage(Point ep, Point[] points) {
        int x = 0;
        int y = 0;
        int count = 0;
        double dist = 0.0;
        for (Point p : points) {
            if (p != null) {
                double d = this.dist(ep, p);
                double a = ((double)this.searchSize - d) * ((double)this.searchSize - d);
                dist += a;
                x = (int)((double)x + (double)p.x * a);
                y = (int)((double)y + (double)p.y * a);
                continue;
            }
            ++count;
        }
        if (count == points.length) {
            return null;
        }
        x = (int)((double)x / dist);
        y = (int)((double)y / dist);
        Point r = new Point(x, y);
        log.info("found point {}", (Object)r);
        return r;
    }
}

