/*
 * Decompiled with CFR 0.152.
 */
package stream.laser;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import stream.laser.ADrawable;

public class Marker
extends ADrawable {
    Float x;
    Float y;
    Color color;
    int radius = 10;

    public Marker(int x, int y, Color color) {
        this.x = Float.valueOf(x);
        this.y = Float.valueOf(y);
        this.color = color;
    }

    public void setPosition(int x, int y) {
        this.x = Float.valueOf(x);
        this.y = Float.valueOf(y);
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public void translate(float dx, float dy) {
        this.x = Float.valueOf(this.x.floatValue() + dx);
        this.y = Float.valueOf(this.y.floatValue() + dy);
    }

    public Point getPoint() {
        return new Point(this.x.intValue(), this.y.intValue());
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.color == null) {
            return;
        }
        Color old = g.getColor();
        g.setColor(this.color);
        g.fillOval(this.x.intValue() - this.radius / 2, this.y.intValue() - this.radius / 2, this.radius, this.radius);
        g.setColor(old);
    }

    public String toString() {
        return "Marker(" + this.x + "," + this.y + ")";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Marker) {
            Marker other = (Marker)o;
            return this.toString().equals(other.toString());
        }
        return false;
    }
}

